/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.fluids.data.FluidBlockstateModelProvider;
import slimeknights.tconstruct.fluids.data.FluidBucketModelProvider;
import tcintegrations.data.EntityTypeTagProvider;
import tcintegrations.data.ModBlockTagsProvider;
import tcintegrations.data.ModItemTagsProvider;
import tcintegrations.data.client.ModBlockStateProvider;
import tcintegrations.data.client.ModItemModelProvider;
import tcintegrations.data.integration.ProjectEConversionProvider;
import tcintegrations.data.loot.ModLootTables;
import tcintegrations.data.recipes.ModRecipesProvider;
import tcintegrations.data.tcon.EnchantmentToModifierProvider;
import tcintegrations.data.tcon.ModifierProvider;
import tcintegrations.data.tcon.ModifierRecipeProvider;
import tcintegrations.data.tcon.ModifierTagProvider;
import tcintegrations.data.tcon.SmelteryRecipeProvider;
import tcintegrations.data.tcon.fluid.FluidEffectProvider;
import tcintegrations.data.tcon.fluid.FluidTagProvider;
import tcintegrations.data.tcon.fluid.FluidTextureProvider;
import tcintegrations.data.tcon.material.MaterialDataProvider;
import tcintegrations.data.tcon.material.MaterialRecipeProvider;
import tcintegrations.data.tcon.material.MaterialRenderInfoProvider;
import tcintegrations.data.tcon.material.MaterialStatsDataProvider;
import tcintegrations.data.tcon.material.MaterialTraitsDataProvider;
import tcintegrations.data.tcon.sprite.TinkerMaterialSpriteProvider;

@Mod.EventBusSubscriber(modid="tcintegrations", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModBlockTagsProvider blockTags = new ModBlockTagsProvider(packOutput, event.getLookupProvider(), existingFileHelper);
        TinkerMaterialSpriteProvider materialSprites = new TinkerMaterialSpriteProvider();
        MaterialDataProvider materials = new MaterialDataProvider(packOutput);
        boolean server = event.includeServer();
        boolean client = event.includeClient();
        gen.addProvider(server, (DataProvider)new ModifierRecipeProvider(packOutput));
        gen.addProvider(server, (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        gen.addProvider(server, (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(server, (DataProvider)blockTags);
        gen.addProvider(server, (DataProvider)new ModItemTagsProvider(packOutput, event.getLookupProvider(), blockTags, existingFileHelper));
        gen.addProvider(server, (DataProvider)new ModRecipesProvider(packOutput));
        gen.addProvider(server, (DataProvider)ModLootTables.create(packOutput));
        gen.addProvider(server, (DataProvider)new EntityTypeTagProvider(packOutput, event.getLookupProvider(), existingFileHelper));
        gen.addProvider(server, (DataProvider)new FluidTagProvider(packOutput, event.getLookupProvider(), existingFileHelper));
        gen.addProvider(client, (DataProvider)new MaterialRenderInfoProvider(packOutput, materialSprites, existingFileHelper));
        gen.addProvider(server, (DataProvider)new MaterialStatsDataProvider(packOutput, materials));
        gen.addProvider(server, (DataProvider)new MaterialTraitsDataProvider(packOutput, materials));
        gen.addProvider(server, (DataProvider)new MaterialRecipeProvider(packOutput));
        gen.addProvider(server, (DataProvider)new SmelteryRecipeProvider(packOutput));
        gen.addProvider(server, (DataProvider)materials);
        gen.addProvider(server, (DataProvider)new ProjectEConversionProvider(packOutput, event.getLookupProvider()));
        gen.addProvider(server, (DataProvider)new ModifierProvider(packOutput));
        gen.addProvider(client, (DataProvider)new FluidTextureProvider(packOutput));
        gen.addProvider(client, (DataProvider)new FluidBlockstateModelProvider(packOutput, "tcintegrations"));
        gen.addProvider(client, (DataProvider)new FluidBucketModelProvider(packOutput, "tcintegrations"));
        gen.addProvider(server, (DataProvider)new FluidEffectProvider(packOutput, "tcintegrations"));
        gen.addProvider(server, (DataProvider)new ModifierTagProvider(packOutput, "tcintegrations", existingFileHelper));
        gen.addProvider(server, (DataProvider)new EnchantmentToModifierProvider(packOutput));
    }
}

