/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.jei.JEIConfig;
import jeresources.jei.worldgen.WorldGenWrapper;
import jeresources.reference.Resources;
import jeresources.util.RenderHelper;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class WorldGenCategory
extends BlankJEIRecipeCategory<WorldGenWrapper> {
    protected static final int X_ITEM = 6;
    protected static final int Y_ITEM = 22;
    protected static final int X_DROP_ITEM = 6;
    protected static final int Y_DROP_ITEM = 67;
    private static final int DROP_ITEM_COUNT = 8;

    public WorldGenCategory() {
        super((IDrawable)JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 32, 16, 16, 16));
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jer.worldgen.title");
    }

    @NotNull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.WORLD_GEN;
    }

    @NotNull
    public RecipeType<WorldGenWrapper> getRecipeType() {
        return JEIConfig.WORLD_GEN_TYPE;
    }

    @Override
    public void draw(@NotNull WorldGenWrapper recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderHelper.drawLine(guiGraphics, 29, 52, 157, 52, -7829368);
        RenderHelper.drawLine(guiGraphics, 29, 52, 29, 12, -7829368);
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull WorldGenWrapper recipeWrapper, @NotNull IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 6, 22).addItemStacks(recipeWrapper.getBlocks())).setSlotName("oreSlot").addTooltipCallback((IRecipeSlotTooltipCallback)recipeWrapper);
        for (int i = 0; i < Math.min(8, recipeWrapper.getDrops().size()); ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 6 + i * 18, 67).addItemStack(recipeWrapper.getDrops().get(i))).addTooltipCallback((IRecipeSlotTooltipCallback)recipeWrapper);
        }
    }
}

