/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.container.data.AbstractDataStore;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;

public class FluidData
extends AbstractDataStore<FluidStack> {
    public FluidData() {
        super(FluidStack.EMPTY);
    }

    public FluidData(FluidStack defaultValue) {
        super(defaultValue);
    }

    @Override
    public void set(FluidStack value) {
        this.value = value.copy();
        this.markDirty();
    }

    @Override
    public void toBytes(MCDataOutput buf) {
        buf.writeFluidStack((FluidStack)this.value);
    }

    @Override
    public void fromBytes(MCDataInput buf) {
        this.value = buf.readFluidStack();
    }

    @Override
    public Tag toTag() {
        return ((FluidStack)this.value).writeToNBT(new CompoundTag());
    }

    @Override
    public void fromTag(Tag tag) {
        this.value = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)tag));
    }

    @Override
    public boolean isSameValue(FluidStack newValue) {
        return ((FluidStack)this.value).equals((Object)newValue);
    }
}

