/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.ConditionBuilder;
import codechicken.lib.datagen.recipe.RecipeBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRecipeBuilder<R, T extends AbstractRecipeBuilder<R, T>>
implements RecipeBuilder {
    protected final Throwable created = new Throwable("Created at");
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    protected final List<ICondition> conditions = new LinkedList<ICondition>();
    protected final RecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final R result;
    private final Set<ItemLike> criteriaItems = new HashSet<ItemLike>();
    private final Set<TagKey<Item>> criteriaTags = new HashSet<TagKey<Item>>();
    private int criteriaCounter = 0;
    protected boolean generateCriteria = false;
    protected boolean enableUnlocking = false;
    private String group;

    protected AbstractRecipeBuilder(RecipeSerializer<?> serializer, ResourceLocation id, R result) {
        this.serializer = serializer;
        this.id = id;
        this.result = result;
    }

    protected T getThis() {
        return (T)((AbstractRecipeBuilder)SneakyUtils.unsafeCast(this));
    }

    protected abstract ResourceLocation getAdvancementId();

    public T withCondition(Function<ConditionBuilder, ICondition> f) {
        this.conditions.add(f.apply(ConditionBuilder.INSTANCE));
        return this.getThis();
    }

    public T enableUnlocking() {
        this.enableUnlocking = true;
        return this.getThis();
    }

    public T autoCriteria() {
        this.enableUnlocking();
        this.generateCriteria = true;
        return this.getThis();
    }

    public T setGroup(String group) {
        this.group = group;
        return this.getThis();
    }

    public T addCriterion(String name, CriterionTriggerInstance criterion) {
        if (!this.enableUnlocking) {
            throw new IllegalStateException("Recipe unlocking must be enabled with 'enableUnlocking'");
        }
        this.advancementBuilder.m_138386_(name, criterion);
        return this.getThis();
    }

    @Override
    public final ResourceLocation getId() {
        return this.id;
    }

    @Override
    public final FinishedRecipe build() {
        this.validate();
        if (this.enableUnlocking) {
            this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        return this._build();
    }

    protected void validate() {
        if (this.enableUnlocking && this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + this.id, this.created);
        }
    }

    protected abstract AbstractFinishedRecipe _build();

    protected void addAutoCriteria(ItemLike item) {
        if (this.generateCriteria && this.criteriaItems.add(item)) {
            this.addCriterion("has_ingredient_" + this.criteriaCounter++, (CriterionTriggerInstance)this.hasItem(item));
        }
    }

    protected void addAutoCriteria(TagKey<Item> tag) {
        if (this.generateCriteria && this.criteriaTags.add(tag)) {
            this.addCriterion("has_ingredient_" + this.criteriaCounter++, (CriterionTriggerInstance)this.hasItem(tag));
        }
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemLike itemIn) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemIn}).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(TagKey<Item> tagIn) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_204145_(tagIn).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    public abstract class AbstractFinishedRecipe
    implements FinishedRecipe {
        public void m_7917_(JsonObject json) {
            if (!AbstractRecipeBuilder.this.conditions.isEmpty()) {
                JsonArray conditionArray = new JsonArray();
                for (ICondition condition : AbstractRecipeBuilder.this.conditions) {
                    conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                json.add("conditions", (JsonElement)conditionArray);
            }
            if (StringUtils.isNotEmpty((CharSequence)AbstractRecipeBuilder.this.group)) {
                json.addProperty("group", AbstractRecipeBuilder.this.group);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return AbstractRecipeBuilder.this.serializer;
        }

        public ResourceLocation m_6445_() {
            return AbstractRecipeBuilder.this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return AbstractRecipeBuilder.this.enableUnlocking ? AbstractRecipeBuilder.this.advancementBuilder.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return AbstractRecipeBuilder.this.getAdvancementId();
        }
    }
}

