/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigCallback;
import codechicken.lib.config.ConfigCategory;
import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.ConfigTag;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigTag<T extends ConfigTag>
implements ConfigTag {
    private final String name;
    @Nullable
    private final ConfigCategory parent;
    protected boolean dirty;
    protected boolean networkSynthetic;
    protected List<String> comment = List.of();
    protected boolean syncToClient = false;
    private final List<ConfigCallback<T>> onModifiedCallbacks = new LinkedList<ConfigCallback<T>>();

    protected AbstractConfigTag(String name, @Nullable ConfigCategoryImpl parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null && parent.syncToClient) {
            this.syncToClient = true;
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public final ConfigCategory getParent() {
        return this.parent;
    }

    public T setComment(String comment) {
        return this.setComment(comment.split("\n"));
    }

    public T setComment(String ... comment) {
        return this.setComment(List.of(comment));
    }

    public T setComment(List<String> comment) {
        this.comment = List.copyOf(comment);
        this.dirty = true;
        return (T)((ConfigTag)SneakyUtils.unsafeCast(this));
    }

    @Override
    public final List<String> getComment() {
        return this.comment;
    }

    public T onSync(ConfigCallback<T> callback) {
        this.onModifiedCallbacks.add(callback);
        return (T)((ConfigTag)SneakyUtils.unsafeCast(this));
    }

    public T syncTagToClient() {
        this.syncToClient = true;
        return (T)((ConfigTag)SneakyUtils.unsafeCast(this));
    }

    @Override
    public boolean requiresClientSync() {
        return this.syncToClient;
    }

    @Override
    public void runSync(ConfigCallback.Reason reason) {
        for (ConfigCallback<ConfigTag> configCallback : this.onModifiedCallbacks) {
            configCallback.onSync((ConfigTag)SneakyUtils.unsafeCast(this), reason);
        }
    }

    @Override
    public boolean isNetworkTag() {
        return this.networkSynthetic;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @ApiStatus.Internal
    public void clearDirty() {
        this.dirty = false;
    }

    @Override
    public ConfigTag copy() {
        return this.copy(null);
    }

    public abstract AbstractConfigTag<T> copy(@Nullable ConfigCategoryImpl var1);
}

