/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_item_rendering;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.render.FastItemRenderType;
import org.embeddedt.modernfix.render.RenderState;
import org.embeddedt.modernfix.render.SimpleItemModelView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class}, priority=600)
@ClientOnlyMixin
public abstract class ItemRendererMixin {
    private ItemDisplayContext transformType;
    private final SimpleItemModelView modelView = new SimpleItemModelView();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void markRenderingType(ItemStack itemStack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model, CallbackInfo ci) {
        this.transformType = transformType;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderModelLists(Lnet/minecraft/client/resources/model/BakedModel;Lnet/minecraft/world/item/ItemStack;IILcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V"), index=0)
    private BakedModel useSimpleWrappedItemModel(BakedModel model, ItemStack stack, int combinedLight, int combinedOverlay, PoseStack matrixStack, VertexConsumer buffer, @Local(ordinal=0) BakedModel originalModel) {
        if (originalModel != null && originalModel.getClass() != SimpleBakedModel.class) {
            return model;
        }
        if (!RenderState.IS_RENDERING_LEVEL && !stack.m_41619_() && model.getClass() == SimpleBakedModel.class && this.transformType == ItemDisplayContext.GUI) {
            FastItemRenderType type;
            ItemTransform transform = model.m_7442_().f_111792_;
            if (transform == ItemTransform.f_111754_) {
                type = FastItemRenderType.SIMPLE_ITEM;
            } else if (stack.m_41720_() instanceof BlockItem && this.isBlockTransforms(transform)) {
                type = FastItemRenderType.SIMPLE_BLOCK;
            } else {
                return model;
            }
            this.modelView.setItem(model);
            this.modelView.setType(type);
            return this.modelView;
        }
        return model;
    }

    private boolean isBlockTransforms(ItemTransform transform) {
        return transform.f_111755_.x() == 30.0f && transform.f_111755_.y() == 225.0f && transform.f_111755_.z() == 0.0f;
    }
}

