/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors;

import immersive_armors.armor_effects.ArrowBlockArmorEffect;
import immersive_armors.armor_effects.BerserkArmorEffect;
import immersive_armors.armor_effects.BouncingArmorEffect;
import immersive_armors.armor_effects.DivineArmorEffect;
import immersive_armors.armor_effects.ExplosionProtectionArmorEffect;
import immersive_armors.armor_effects.FireInflictingArmorEffect;
import immersive_armors.armor_effects.FireResistanceArmorEffect;
import immersive_armors.armor_effects.MagicProtectionArmorEffect;
import immersive_armors.armor_effects.SpikesArmorEffect;
import immersive_armors.armor_effects.SteamTechArmorEffect;
import immersive_armors.armor_effects.WeaponEfficiency;
import immersive_armors.armor_effects.WitherArmorEffect;
import immersive_armors.cobalt.registration.Registration;
import immersive_armors.item.DyeableExtendedArmorItem;
import immersive_armors.item.ExtendedArmorItem;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public interface Items {
    public static final Map<String, Supplier<Item>> coloredItems = new HashMap<String, Supplier<Item>>();
    public static final Map<String, Supplier<Item>> items = new HashMap<String, Supplier<Item>>();
    public static final List<Supplier<Item>> itemsOrdered = new LinkedList<Supplier<Item>>();
    public static final Map<String, Map<Supplier<Item>, Float>> lootLookup = new HashMap<String, Map<Supplier<Item>, Float>>();
    public static final ExtendedArmorMaterial BONE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("bone").addLoot("minecraft:chests/village/village_weaponsmith", 1.0f).addLoot("minecraft:chests/jungle_temple", 1.0f).durabilityMultiplier(8).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42500_})).protectionAmount(1, 3, 2, 1).enchantability(15).equipSound(SoundEvents.f_12423_).antiSkeleton().weight(-0.02f));
    public static final ExtendedArmorMaterial WITHER_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wither").addLoot("minecraft:chests/jungle_temple", 0.5f).addLoot("minecraft:chests/ruined_portal", 1.0f).addLoot("minecraft:chests/bastion_other", 1.0f).durabilityMultiplier(12).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42500_})).protectionAmount(2, 4, 3, 2).enchantability(0).effect(new WitherArmorEffect(1.0f, 10)).hideCape().equipSound(SoundEvents.f_12559_).antiSkeleton().weight(-0.01f));
    public static final ExtendedArmorMaterial WARRIOR_ARMOR = Items.registerSet(new ExtendedArmorMaterial("warrior").addLoot("minecraft:chests/village/village_armorer", 1.0f).addLoot("minecraft:chests/shipwreck_supply", 1.0f).protectionAmount(2, 5, 6, 2).durabilityMultiplier(15).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42416_})).toughness(1.0f).enchantability(5).hideCape().effect(new BerserkArmorEffect(0.2f)).effect(new WeaponEfficiency(0.05f, new ResourceLocation("immersive_armors:axes"), "axe")).equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial HEAVY_ARMOR = Items.registerSet(new ExtendedArmorMaterial("heavy").addLoot("minecraft:chests/village/village_armorer", 1.0f).addLoot("minecraft:chests/stronghold_crossing", 1.0f).protectionAmount(4, 6, 5, 3).durabilityMultiplier(20).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42416_})).toughness(4.0f).knockbackReduction(0.5f).weight(0.05f).enchantability(6).equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial ROBE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("robe").addLoot("minecraft:chests/village/village_shepherd", 0.25f).addLoot("minecraft:chests/woodland_mansion", 1.0f).addLoot("minecraft:chests/igloo_chest", 1.0f).protectionAmount(2, 3, 2, 1).enchantability(50).durabilityMultiplier(14).repairIngredient(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13167_)).color(11546150).effect(new FireResistanceArmorEffect(0.25f)).effect(new FireInflictingArmorEffect(10)).effect(new MagicProtectionArmorEffect(0.2f)).equipSound(SoundEvents.f_12642_));
    public static final ExtendedArmorMaterial SLIME_ARMOR = Items.registerSet(new ExtendedArmorMaterial("slime").addLoot("minecraft:chests/simple_dungeon", 0.25f).protectionAmount(3, 5, 4, 2).enchantability(10).durabilityMultiplier(20).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42518_})).knockbackReduction(0.25f).effect(new BouncingArmorEffect(0.25f)).effect(new ExplosionProtectionArmorEffect(0.2f)).equipSound(SoundEvents.f_12388_));
    public static final ExtendedArmorMaterial DIVINE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("divine").addLoot("minecraft:chests/village/village_temple", 0.4f).addLoot("minecraft:chests/bastion_treasure", 0.25f).addLoot("minecraft:chests/woodland_mansion", 0.25f).addLoot("minecraft:chests/desert_pyramid", 1.0f).addLoot("minecraft:blocks/coal_block", 0.1f).protectionAmount(3, 7, 5, 3).durabilityMultiplier(18).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42417_})).enchantability(30).effect(new DivineArmorEffect(1200L)).color(11546150).hideCape().equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial PRISMARINE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("prismarine").addLoot("minecraft:chests/underwater_ruin_big", 1.0f).addLoot("minecraft:chests/underwater_ruin_small", 0.5f).protectionAmount(3, 8, 6, 3).enchantability(8).durabilityMultiplier(18).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42696_})).weight(0.02f).effect(new SpikesArmorEffect(1)).enchantment(Enchantments.f_44973_, 2).equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial WOODEN_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wooden").addLoot("minecraft:chests/village/village_fletcher", 0.25f).protectionAmount(1, 3, 2, 1).durabilityMultiplier(8).repairIngredient(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13182_)).enchantability(4).effect(new ArrowBlockArmorEffect(0.15f)).effect(new ExplosionProtectionArmorEffect(0.1f)).equipSound(SoundEvents.f_11678_));
    public static final ExtendedArmorMaterial STEAMPUNK_ARMOR = Items.registerSet(new ExtendedArmorMaterial("steampunk").addLoot("minecraft:chests/village/village_toolsmith", 0.25f).addLoot("minecraft:chests/shipwreck_treasure", 1.0f).protectionAmount(3, 6, 3, 2).durabilityMultiplier(10).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42417_})).enchantability(4).hideCape().effect(new ExplosionProtectionArmorEffect(0.1f)).effect(new SteamTechArmorEffect()).equipSound(SoundEvents.f_12374_));

    public static void bootstrap() {
    }

    public static ExtendedArmorMaterial registerSet(ExtendedArmorMaterial material) {
        items.putAll(Items.register(material.m_6082_() + "_helmet", () -> new ExtendedArmorItem(Items.baseProps(), ArmorItem.Type.HELMET, material), material));
        items.putAll(Items.register(material.m_6082_() + "_chestplate", () -> new ExtendedArmorItem(Items.baseProps(), ArmorItem.Type.CHESTPLATE, material), material));
        items.putAll(Items.register(material.m_6082_() + "_leggings", () -> new ExtendedArmorItem(Items.baseProps(), ArmorItem.Type.LEGGINGS, material), material));
        items.putAll(Items.register(material.m_6082_() + "_boots", () -> new ExtendedArmorItem(Items.baseProps(), ArmorItem.Type.BOOTS, material), material));
        return material;
    }

    public static ExtendedArmorMaterial registerDyeableSet(ExtendedArmorMaterial material) {
        coloredItems.putAll(Items.register(material.m_6082_() + "_helmet", () -> new DyeableExtendedArmorItem(Items.baseProps(), ArmorItem.Type.HELMET, material), material));
        coloredItems.putAll(Items.register(material.m_6082_() + "_chestplate", () -> new DyeableExtendedArmorItem(Items.baseProps(), ArmorItem.Type.CHESTPLATE, material), material));
        coloredItems.putAll(Items.register(material.m_6082_() + "_leggings", () -> new DyeableExtendedArmorItem(Items.baseProps(), ArmorItem.Type.LEGGINGS, material), material));
        coloredItems.putAll(Items.register(material.m_6082_() + "_boots", () -> new DyeableExtendedArmorItem(Items.baseProps(), ArmorItem.Type.BOOTS, material), material));
        items.putAll(coloredItems);
        return material;
    }

    public static Map<String, Supplier<Item>> register(String name, Supplier<Item> item, ExtendedArmorMaterial material) {
        Supplier<Item> register = Registration.register(BuiltInRegistries.f_257033_, new ResourceLocation("immersive_armors", name), item);
        for (Map.Entry<String, Float> entry : material.getLoot().entrySet()) {
            lootLookup.putIfAbsent(entry.getKey(), new HashMap());
            lootLookup.get(entry.getKey()).put(register, entry.getValue());
        }
        itemsOrdered.add(register);
        return Collections.singletonMap(name, register);
    }

    public static Item.Properties baseProps() {
        return new Item.Properties();
    }

    public static List<ItemStack> getSortedItems() {
        return itemsOrdered.stream().map(i -> ((Item)i.get()).m_7968_()).toList();
    }
}

