/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.shieldsplus.world.item.enchantment;

import insane96mcp.shieldsplus.setup.SPSoundEvents;
import insane96mcp.shieldsplus.world.item.SPShieldItem;
import insane96mcp.shieldsplus.world.item.enchantment.IBlockingEffect;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;

public class CelestialGuardianEnchantment
extends Enchantment
implements IBlockingEffect {
    public static String LAST_TRIGGER_TAG = "shieldsplus:celestial_guardian_last_trigger";
    public static String SHOULD_APPLY_TAG = "shieldsplus:celestial_guardian";

    public CelestialGuardianEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, SPShieldItem.ENCHANTMENT_CATEGORY, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
    }

    public int m_6183_(int pEnchantmentLevel) {
        return pEnchantmentLevel * 25;
    }

    public int m_6175_(int pEnchantmentLevel) {
        return this.m_6183_(pEnchantmentLevel) + 50;
    }

    public boolean m_6591_() {
        return true;
    }

    @Override
    public void onBlocked(LivingEntity blockingEntity, DamageSource source, float amount, int lvl, ShieldBlockEvent event) {
        if (lvl <= 0 || blockingEntity.getPersistentData().m_128454_(LAST_TRIGGER_TAG) + 2400L > blockingEntity.m_9236_().m_46467_()) {
            return;
        }
        blockingEntity.getPersistentData().m_128379_(SHOULD_APPLY_TAG, true);
        blockingEntity.getPersistentData().m_128356_(LAST_TRIGGER_TAG, blockingEntity.m_9236_().m_46467_());
    }

    public static void trySaveAmount(LivingEntity entity, float amount) {
        if (!entity.getPersistentData().m_128441_(SHOULD_APPLY_TAG)) {
            return;
        }
        entity.getPersistentData().m_128350_(SHOULD_APPLY_TAG, amount);
    }

    public static boolean tryApply(LivingEntity entity) {
        if (!entity.m_21254_() || !entity.getPersistentData().m_128441_(SHOULD_APPLY_TAG)) {
            return false;
        }
        float amount = entity.getPersistentData().m_128457_(SHOULD_APPLY_TAG);
        entity.getPersistentData().m_128473_(SHOULD_APPLY_TAG);
        float health = entity.m_21223_();
        if ((health - amount) / entity.m_21233_() > 0.25f) {
            return false;
        }
        float maxAmount = Math.min(amount, health);
        health -= maxAmount;
        amount -= maxAmount;
        entity.m_9236_().m_6269_(null, (Entity)entity, (SoundEvent)SPSoundEvents.CELESTIAL_GUARDIAN.get(), entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 1200, 4));
        if (health <= 0.0f && amount < 20.0f) {
            entity.m_7911_(entity.m_6103_() - amount);
            return true;
        }
        return false;
    }
}

