/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.shieldsplus.world.item;

import insane96mcp.shieldsplus.ShieldsPlus;
import insane96mcp.shieldsplus.data.ShieldDefinition;
import insane96mcp.shieldsplus.module.BaseFeature;
import insane96mcp.shieldsplus.render.ShieldBlockEntityWithoutLevelRenderer;
import insane96mcp.shieldsplus.setup.SPEnchantments;
import insane96mcp.shieldsplus.setup.client.ClientMaterials;
import insane96mcp.shieldsplus.world.item.SPShieldMaterial;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPShieldItem
extends ShieldItem {
    public static final ShieldDefinition DEFAULT_SHIELD_DEFINITION = new ShieldDefinition(2.0f, 50, 20);
    public static final String DAMAGE_BLOCKED = "shieldsplus:damage_blocked";
    public static final String BLOCKING_TIME = "shieldsplus:blocking_time";
    public static final String COOLDOWN = "shieldsplus:cooldown";
    public static final String DAMAGE_REFLECTED = "shieldsplus:damage_reflected";
    public static final String CAPPED_DAMAGE_REFLECTED = "shieldsplus:capped_damage_reflected";
    public static final EnchantmentCategory ENCHANTMENT_CATEGORY = EnchantmentCategory.create((String)"shield", s -> s instanceof ShieldItem);
    public static final ResourceLocation BLOCKING = new ResourceLocation("minecraft:blocking");
    public final SPShieldMaterial material;
    public ClientMaterials clientMaterials;
    public ShieldDefinition shieldDefinition = DEFAULT_SHIELD_DEFINITION;

    public SPShieldItem(SPShieldMaterial material, Item.Properties p_43089_) {
        super(p_43089_);
        this.material = material;
    }

    public String m_5671_(ItemStack pStack) {
        return this.m_5524_();
    }

    public float getBlockedDamage(ItemStack stack, @Nullable LivingEntity entity, Level level) {
        return this.shieldDefinition.blockedDamage;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        if (!BaseFeature.liftedAndCooldown.booleanValue()) {
            return 72000;
        }
        return this.shieldDefinition.blockingTicks == 0 ? 72000 : this.shieldDefinition.blockingTicks;
    }

    public int getCooldown(ItemStack stack, @Nullable LivingEntity entity, Level level) {
        return this.shieldDefinition.cooldownTicks;
    }

    public int calculateCooldownFromTimeLifted(ItemStack stack, @Nullable LivingEntity entity, Level level, int timeLifted) {
        int fastRecovery;
        double maxCooldown;
        double cooldown = maxCooldown = (double)this.getCooldown(stack, entity, level);
        int useDuration = this.m_8105_(stack);
        timeLifted = useDuration - timeLifted;
        if ((cooldown *= (double)timeLifted / (double)useDuration) / maxCooldown < BaseFeature.minCooldown) {
            cooldown = maxCooldown * BaseFeature.minCooldown;
        }
        if ((fastRecovery = stack.getEnchantmentLevel((Enchantment)SPEnchantments.FAST_RECOVERY.get())) > 0) {
            cooldown = (int)(cooldown * (1.0 - BaseFeature.enchantments$fastRecoveryCooldownReduction));
        }
        return (int)cooldown;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (!BaseFeature.liftedAndCooldown.booleanValue()) {
            return stack;
        }
        int cooldown = this.calculateCooldownFromTimeLifted(stack, livingEntity, level, livingEntity.m_21212_());
        if (cooldown > 0 && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36335_().m_41524_(stack.m_41720_(), cooldown);
        }
        return stack;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        if (!BaseFeature.liftedAndCooldown.booleanValue()) {
            return;
        }
        int cooldown = this.calculateCooldownFromTimeLifted(stack, entity, entity.m_9236_(), entity.m_21212_());
        if (cooldown > 0 && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_(stack.m_41720_(), cooldown);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ShieldBlockEntityWithoutLevelRenderer.instance;
            }
        });
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.material.enchantmentValue;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        SPShieldItem.addDamageBlockedText(itemStack, components, this.getBlockedDamage(itemStack, null, level));
        int useDuration = this.m_8105_(itemStack);
        if (useDuration < 72000 && BaseFeature.liftedAndCooldown.booleanValue()) {
            components.add((Component)Component.m_237110_((String)BLOCKING_TIME, (Object[])new Object[]{ShieldsPlus.ONE_DECIMAL_FORMATTER.format((float)useDuration / 20.0f)}).m_130940_(ChatFormatting.BLUE));
            components.add((Component)Component.m_237110_((String)COOLDOWN, (Object[])new Object[]{ShieldsPlus.ONE_DECIMAL_FORMATTER.format((float)this.getCooldown(itemStack, null, level) / 20.0f)}).m_130940_(ChatFormatting.BLUE));
        }
    }

    public static void addDamageBlockedText(ItemStack itemStack, List<Component> components, double blockedDamage) {
        if (!BaseFeature.shieldBlockFixedDamageAmount.booleanValue()) {
            return;
        }
        int reinforced = itemStack.getEnchantmentLevel((Enchantment)SPEnchantments.REINFORCED.get());
        components.add((Component)Component.m_237110_((String)DAMAGE_BLOCKED, (Object[])new Object[]{ShieldsPlus.ONE_DECIMAL_FORMATTER.format(blockedDamage)}).m_130940_(ChatFormatting.BLUE));
    }

    public boolean m_6832_(@NotNull ItemStack repaired, @NotNull ItemStack repairingMaterial) {
        if (this.material.repairItem != null) {
            return repairingMaterial.m_150930_(this.material.repairItem.get());
        }
        return repairingMaterial.m_204117_(this.material.repairTag);
    }

    public void tryCacheClientMaterials() {
        if (this.clientMaterials == null) {
            this.clientMaterials = new ClientMaterials(new Material(Sheets.f_110738_, new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)this).m_135827_(), "entity/shield/%s_shield_nopattern".formatted(this.material.materialName))), new Material(Sheets.f_110738_, new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)this).m_135827_(), "entity/shield/%s_shield".formatted(this.material.materialName))));
        }
    }

    public Material getClientMaterial(boolean hasBanner) {
        this.tryCacheClientMaterials();
        return hasBanner ? this.clientMaterials.patternMaterial() : this.clientMaterials.noPatternMaterial();
    }
}

