/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.shieldsplus.module;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.shieldsplus.ShieldsPlus;
import insane96mcp.shieldsplus.data.ShieldDefinition;
import insane96mcp.shieldsplus.data.ShieldDefinitionReloader;
import insane96mcp.shieldsplus.event.SPEventFactory;
import insane96mcp.shieldsplus.world.item.SPShieldItem;
import insane96mcp.shieldsplus.world.item.enchantment.AegisEnchantment;
import insane96mcp.shieldsplus.world.item.enchantment.CelestialGuardianEnchantment;
import insane96mcp.shieldsplus.world.item.enchantment.IBlockingEffect;
import insane96mcp.shieldsplus.world.item.enchantment.LightweightEnchantment;
import insane96mcp.shieldsplus.world.item.enchantment.ReinforcedEnchantment;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="shieldsplus:base", canBeDisabled=false, name="Shields+")
public class BaseFeature
extends Feature {
    public static final TagKey<Item> REQUIRE_TWO_HANDS_ITEM_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ShieldsPlus.location("requires_two_hands"));
    @Config(min=0.0, description="In vanilla when you start blocking with a shield, there's a 0.25 seconds (5 ticks) window where you are still not blocking. By default the windup is removed.")
    public static Integer shieldWindup = 0;
    @Config(description="If true shields will block only a certain amount of damage. If false the vanilla behaviour is used.")
    public static Boolean shieldBlockFixedDamageAmount = true;
    @Config(min=0.0, max=3.4028234663852886E38, description="The minimum damage dealt to the player for the shield to take damage. Vanilla is 3. E.g. With this set to 3, the shield will not be damaged if damage received is lower than 3.")
    public static Double minShieldHurtDamage = 0.0;
    @Config(description="Makes shields always disable for 1.6 seconds like Combat Test snapshots.")
    public static Boolean combatTestShieldDisabling = true;
    @Config(description="If true, crouching will block with the shield and you can attack while blocking.")
    public static Boolean blockWithCrouch = true;
    @Config(description="If true, shields can be lifted only for a certain amount of time and will go on cooldown.")
    public static Boolean liftedAndCooldown = true;
    @Config(min=0.0, max=1.0, description="When shields go on cooldown, the time is given by how much time the shield has been blocking. This defines the minimum cooldown in percentage for the shield to go on cooldown (e.g. if you just block for a few ticks, the cooldown will be 30% of the max cooldown).")
    public static Double minCooldown = 0.3;
    @Config(min=1.0, description="How many seconds will ablaze set entities on fire per level.")
    public static Integer enchantments$ablazeTimeOnFire = 2;
    @Config(min=0.0, max=1.0, description="How much damage will the aegis enchantment negate per level.")
    public static Double enchantments$aegisPercentageDamageReduction = 0.1;
    @Config(min=0.0, max=1.0, description="Percentage cooldown reduction with the Fast Recovery enchantment.")
    public static Double enchantments$fastRecoveryCooldownReduction = 0.35;
    @Config(min=0.0, description="Percentage increase of speed when blocking with the Lightweight enchantment.")
    public static Double enchantments$lightweightBonusSpeed = 2.0;
    @Config(min=0.0, max=10.0, description="Max ticks for a perfect parry.")
    public static Integer enchantments$perfectParryTickWindow = 1;
    @Config(min=0.0, description="Amount of knockback given to entities per level.")
    public static Double enchantments$recoilEntitiesKnockback = 0.5;
    @Config(min=0.0, description="Amount of knockback given to projectiles per level.")
    public static Double enchantments$recoilProjectilesKnockback = 5.0;
    @Config(min=0.0, max=1.0, description="Percentage amount of damage reflected.")
    public static Double enchantments$reflectionReflectedDamage = 0.08;
    @Config(min=0.0, max=1.0, description="Percentage bonus amount of damage blocked.")
    public static Double enchantments$reinforcedBlockedDamageBonus = 0.1;

    @SubscribeEvent
    public void onShieldBlock(ShieldBlockEvent event) {
        if (shieldBlockFixedDamageAmount.booleanValue()) {
            Item item = event.getEntity().m_21211_().m_41720_();
            if (item instanceof SPShieldItem) {
                SPShieldItem spShieldItem = (SPShieldItem)item;
                float baseBlockedDamage = spShieldItem.getBlockedDamage(event.getEntity().m_21211_(), event.getEntity(), event.getEntity().m_9236_());
                float blockedDamage = ReinforcedEnchantment.increaseDamageBlocked(event.getEntity().m_21211_(), baseBlockedDamage);
                event.setBlockedDamage(blockedDamage);
            } else {
                Optional<ShieldDefinition> shieldDefinition = ShieldDefinitionReloader.getShieldDefinition(event.getEntity().m_21211_());
                shieldDefinition.ifPresent(def -> {
                    float blockedDamage = ReinforcedEnchantment.increaseDamageBlocked(event.getEntity().m_21211_(), def.blockedDamage);
                    event.setBlockedDamage(blockedDamage);
                });
            }
        }
        if (event.getEntity().m_21211_().m_41720_() instanceof ShieldItem) {
            event.getEntity().m_21211_().getAllEnchantments().forEach((enchantment, lvl) -> {
                if (enchantment instanceof IBlockingEffect) {
                    IBlockingEffect blockingEffectEnchantment = (IBlockingEffect)enchantment;
                    blockingEffectEnchantment.onBlocked(event.getEntity(), event.getDamageSource(), event.getBlockedDamage(), (int)lvl, event);
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        AegisEnchantment.reduceDamage(event);
        CelestialGuardianEnchantment.trySaveAmount(event.getEntity(), event.getAmount());
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (CelestialGuardianEnchantment.tryApply(event.getEntity())) {
            event.getEntity().m_21153_(1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            LightweightEnchantment.onTick(event.player);
        }
        if (BaseFeature.canBlockWithCrouch((LivingEntity)event.player) && !event.player.m_6117_() && event.player.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK) && !CrossbowItem.m_40932_((ItemStack)event.player.m_21205_()) && !event.player.m_21205_().m_204117_(REQUIRE_TWO_HANDS_ITEM_TAG)) {
            event.player.m_6672_(InteractionHand.OFF_HAND);
        }
    }

    public static boolean canBlockWithCrouch(LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36335_().m_41519_(player.m_21206_().m_41720_())) {
            return false;
        }
        return blockWithCrouch != false && livingEntity.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK) && livingEntity.m_6047_() && SPEventFactory.canBlockWithCrouch(livingEntity, livingEntity.m_21206_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled() || !shieldBlockFixedDamageAmount.booleanValue() || event.getItemStack().m_41720_() instanceof SPShieldItem) {
            return;
        }
        Optional<ShieldDefinition> shieldDefinition = ShieldDefinitionReloader.getShieldDefinition(event.getItemStack());
        if (shieldDefinition.isEmpty()) {
            return;
        }
        SPShieldItem.addDamageBlockedText(event.getItemStack(), event.getToolTip(), shieldDefinition.get().blockedDamage);
    }

    public static boolean shouldRemoveShieldWindup() {
        return BaseFeature.isEnabled(BaseFeature.class) && shieldWindup != 5;
    }

    public static boolean combatTestShieldDisabling() {
        return BaseFeature.isEnabled(BaseFeature.class) && combatTestShieldDisabling != false;
    }
}

