/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.shieldsplus.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.shieldsplus.data.ShieldDefinition;
import insane96mcp.shieldsplus.network.ClientUpdateShieldDefinitionMessage;
import insane96mcp.shieldsplus.world.item.SPShieldItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="shieldsplus")
public class ShieldDefinitionReloader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ShieldDefinitionReloader INSTANCE;
    public static final List<ShieldDefinition> SHIELD_DEFINITIONS;

    public ShieldDefinitionReloader() {
        super(GSON, "shield_definitions");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        SHIELD_DEFINITIONS.clear();
        try {
            map.forEach((resourceLocation, jElement) -> {
                ShieldDefinition shieldDefinition = (ShieldDefinition)GSON.fromJson(jElement, ShieldDefinition.class);
                shieldDefinition.id = resourceLocation;
                ShieldDefinitionReloader.apply(shieldDefinition);
                SHIELD_DEFINITIONS.add(shieldDefinition);
            });
        }
        catch (JsonSyntaxException e) {
            LogHelper.error((String)"Parsing error loading Shield Definition: %s", (Object[])new Object[]{e});
        }
        catch (Exception e) {
            LogHelper.error((String)"Failed loading Shield Definition: %s", (Object[])new Object[]{e});
        }
    }

    public static void apply(List<ShieldDefinition> map) {
        map.forEach(ShieldDefinitionReloader::apply);
    }

    public static void apply(ShieldDefinition shieldDefinition) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(shieldDefinition.id);
        if (!(item instanceof SPShieldItem)) {
            return;
        }
        SPShieldItem spShieldItem = (SPShieldItem)item;
        spShieldItem.shieldDefinition = shieldDefinition;
    }

    public static Optional<ShieldDefinition> getShieldDefinition(ItemStack itemStack) {
        for (ShieldDefinition shieldDefinition : SHIELD_DEFINITIONS) {
            if (!shieldDefinition.id.equals((Object)ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()))) continue;
            return Optional.of(shieldDefinition);
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            event.getPlayerList().m_11314_().forEach(player -> ClientUpdateShieldDefinitionMessage.sync(SHIELD_DEFINITIONS, player));
        } else {
            ClientUpdateShieldDefinitionMessage.sync(SHIELD_DEFINITIONS, event.getPlayer());
        }
    }

    static {
        SHIELD_DEFINITIONS = new ArrayList<ShieldDefinition>();
        INSTANCE = new ShieldDefinitionReloader();
    }
}

