/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BubbleBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BubbleBlock
extends Block
implements EntityBlock {
    public BubbleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext placeContext) {
        return !placeContext.m_7078_();
    }

    public boolean m_48673_(BlockState blockState) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ec;
        if (collisionContext.m_6513_(Shapes.m_83144_(), pos, false) && collisionContext instanceof EntityCollisionContext && (ec = (EntityCollisionContext)collisionContext).m_193113_() instanceof LivingEntity) {
            return Shapes.m_83144_();
        }
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (CommonConfigs.Tools.BUBBLE_BREAK.get().booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BubbleBlock.breakBubble((Level)serverLevel, pos, state);
        }
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        this.makeParticle(pos, level);
        BubbleBlock.playBreakSound(state, level, pos, player);
    }

    private static void playBreakSound(BlockState state, Level level, BlockPos pos, Player player) {
        SoundType soundtype = state.m_60827_();
        level.m_5594_(player, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public void makeParticle(BlockPos pos, Level level) {
        level.m_7106_((ParticleOptions)ModParticles.BUBBLE_BLOCK_PARTICLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
    }

    public static void sendParticles(BlockPos pos, ServerLevel level) {
        level.m_8767_((ParticleOptions)ModParticles.BUBBLE_BLOCK_PARTICLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void breakBubble(Level level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            level.m_7471_(pos, false);
            BubbleBlock.sendParticles(pos, sl);
            BubbleBlock.playBreakSound(state, level, pos, null);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (this.canPopBubble(entity)) {
            level.m_186460_(pos, (Block)this, 5);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float v) {
        super.m_142072_(level, state, pos, entity, v);
        if (!level.f_46443_ && CommonConfigs.Tools.BUBBLE_BREAK.get().booleanValue() && this.canPopBubble(entity)) {
            if (v > 3.0f) {
                BubbleBlock.breakBubble(level, pos, state);
            } else {
                level.m_186460_(pos, (Block)this, (int)Mth.m_14036_((float)(7.0f - v / 2.0f), (float)1.0f, (float)5.0f));
            }
        }
    }

    protected boolean canPopBubble(Entity entity) {
        if (!CommonConfigs.Tools.BUBBLE_BREAK.get().booleanValue()) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return CommonConfigs.Tools.BUBBLE_FEATHER_FALLING.get() == false || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44967_, (LivingEntity)le) == 0;
        }
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        BubbleBlock.breakBubble((Level)serverLevel, pos, state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BubbleBlockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> tBlockEntityType) {
        return Utils.getTicker(tBlockEntityType, ModRegistry.BUBBLE_BLOCK_TILE.get(), BubbleBlockTile::tick);
    }
}

