/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.init;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.client.hud.HudManager;
import com.brandon3055.brandonscore.client.model.EquippedItemModelLayer;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.utils.BCProfiler;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init() {
        LOCK.lock();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(BCGuiTextures::onResourceReload);
        modBus.addListener(ClientInit::clientSetupEvent);
        modBus.addListener(ClientInit::onAddRenderLayers);
        MinecraftForge.EVENT_BUS.addListener(event -> ContributorHandler.onClientLogin((Player)event.getPlayer()));
        ProcessHandlerClient.init();
        HudManager.init();
        BCShaders.init();
        BCProfiler.init();
        DLRSCache.init();
    }

    private static void clientSetupEvent(FMLClientSetupEvent event) {
        BCClientEventHandler.init();
    }

    private static void onAddRenderLayers(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer renderer;
        for (String skin : event.getSkins()) {
            renderer = event.getSkin(skin);
            assert (renderer != null);
            renderer.m_115326_(new EquippedItemModelLayer(renderer, skin.equals("slim")));
        }
        for (EntityRenderer r : Minecraft.m_91087_().m_91290_().f_114362_.values()) {
            if (!(r instanceof LivingEntityRenderer) || !((renderer = (LivingEntityRenderer)r).m_7200_() instanceof HumanoidModel)) continue;
            renderer.m_115326_(new EquippedItemModelLayer(renderer, false));
        }
    }
}

