/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.hud;

import codechicken.lib.gui.modular.lib.GuiRender;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.hud.HudData;
import com.brandon3055.brandonscore.client.hud.HudDataElement;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;

public class HudManager {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    public static final ResourceKey<Registry<AbstractHudElement>> HUD_TYPE = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("brandonscore", "hud_elements"));
    public static IForgeRegistry<AbstractHudElement> HUD_REGISTRY;
    protected static Map<ResourceLocation, AbstractHudElement> hudElements;

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(HudManager::onDrawOverlayPre);
        MinecraftForge.EVENT_BUS.addListener(HudManager::onDrawOverlayPost);
        MinecraftForge.EVENT_BUS.addListener(HudManager::onClientTick);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HudManager::createRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HudManager::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HudManager::registerBuiltIn);
    }

    public static void onDrawOverlayPre(RenderGuiEvent.Pre event) {
        if (event.isCanceled()) {
            return;
        }
        GuiRender render = GuiRender.convert((GuiGraphics)event.getGuiGraphics());
        boolean configuring = Minecraft.m_91087_().f_91080_ instanceof HudConfigGui.Screen;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (AbstractHudElement element : hudElements.values()) {
            if (!element.shouldRender(true)) continue;
            render.pose().m_85836_();
            element.render(render, event.getPartialTick(), configuring);
            render.pose().m_85849_();
        }
    }

    public static void onDrawOverlayPost(RenderGuiEvent.Post event) {
        if (event.isCanceled()) {
            return;
        }
        GuiRender render = GuiRender.convert((GuiGraphics)event.getGuiGraphics());
        boolean configuring = Minecraft.m_91087_().f_91080_ instanceof HudConfigGui.Screen;
        for (AbstractHudElement element : hudElements.values()) {
            if (!element.shouldRender(false)) continue;
            render.pose().m_85836_();
            element.render(render, event.getPartialTick(), configuring);
            render.pose().m_85849_();
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        boolean configuring = Minecraft.m_91087_().f_91080_ instanceof HudConfigGui.Screen;
        for (AbstractHudElement element : hudElements.values()) {
            element.tick(configuring);
        }
        HudData.clientTick();
    }

    private static void createRegistry(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(HUD_TYPE.m_135782_()).disableSaving().disableSync(), ts -> {
            HUD_REGISTRY = ts;
        });
    }

    private static void onLoadComplete(FMLLoadCompleteEvent event) {
        hudElements.clear();
        for (ResourceLocation key : HUD_REGISTRY.getKeys()) {
            hudElements.put(key, (AbstractHudElement)HUD_REGISTRY.getValue(key));
        }
        HudData.loadSettings();
    }

    public static void registerBuiltIn(RegisterEvent event) {
        event.register(HUD_TYPE, new ResourceLocation("brandonscore", "item_hud"), () -> new HudDataElement(new Vector2(0.0, 0.20494), true, false).setEnabled(false));
        event.register(HUD_TYPE, new ResourceLocation("brandonscore", "block_hud"), () -> new HudDataElement(new Vector2(0.0, 0.04593), false, true).setEnabled(false));
        event.register(HUD_TYPE, new ResourceLocation("brandonscore", "block_item_hud"), () -> new HudDataElement(new Vector2(0.99023, 0.72438), true, true));
    }

    public static Map<ResourceLocation, AbstractHudElement> getHudElements() {
        return ImmutableMap.copyOf(hudElements);
    }

    @Nullable
    public static AbstractHudElement getHudElement(ResourceLocation key) {
        return hudElements.get(key);
    }

    static {
        hudElements = new HashMap<ResourceLocation, AbstractHudElement>();
    }
}

