/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.exception.TickingException;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.client.ClientTickHandler;
import com.bawnorton.neruina.mixin.accessor.WorldChunkAccessor;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.MultiSetMap;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.VersionedText;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class TickHandler {
    private final List<TickingEntry> recentErrors = new ArrayList<TickingEntry>();
    private final Map<UUID, TickingEntry> tickingEntries = new HashMap<UUID, TickingEntry>();
    private final MultiSetMap<BlockState, BlockPos> erroredBlockStates = new MultiSetMap();
    private int stopwatch = 0;

    public void tick() {
        ++this.stopwatch;
        if (this.stopwatch >= 600) {
            if (!this.recentErrors.isEmpty()) {
                this.recentErrors.remove(0);
            }
            this.stopwatch = 0;
        }
    }

    public void init() {
        this.tickingEntries.clear();
        this.recentErrors.clear();
    }

    public void safelyTickItemStack(ItemStack instance, Level world, Entity entity, int slot, boolean selected, Operation<Void> original) {
        try {
            if (this.isErrored(instance)) {
                return;
            }
            original.call(new Object[]{instance, world, entity, slot, selected});
        }
        catch (Throwable e) {
            this.handleTickingItemStack(e, instance, !world.m_5776_(), (Player)entity, slot);
        }
    }

    public void safelyTickItemStack(ItemStack instance, Level world, Player player, int slot, int selected, Operation<Void> original) {
        try {
            if (this.isErrored(instance)) {
                return;
            }
            original.call(new Object[]{instance, world, player, slot, selected});
        }
        catch (Throwable e) {
            this.handleTickingItemStack(e, instance, !world.m_5776_(), player, slot);
        }
    }

    public void safelyTickEntities(Consumer<Object> instance, Entity entity, Operation<Void> original) {
        try {
            if (this.isErrored(entity)) {
                this.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{instance, entity});
        }
        catch (TickingException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingEntities.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_entities", e);
            }
            this.handleTickingEntity(entity, e);
        }
    }

    public <T extends Entity> void safelyTickEntities(Consumer<T> consumer, T entity, Level world, Object random, Operation<Void> original) {
        try {
            if (this.isErrored(entity)) {
                this.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{consumer, entity, world, random});
        }
        catch (TickingException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingEntities.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_entities", e);
            }
            this.handleTickingEntity(entity, e);
        }
    }

    public void safelyTickPlayer(ServerPlayer instance, Operation<Void> original) {
        try {
            original.call(new Object[]{instance});
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingPlayers.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_players", e);
            }
            this.handleTickingPlayer(instance, e);
        }
    }

    public void safelyTickBlockState(BlockState instance, ServerLevel world, BlockPos pos, Object random, Operation<Void> original) {
        try {
            if (this.isErrored(instance, pos)) {
                return;
            }
            original.call(new Object[]{instance, world, pos, random});
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingBlockStates.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_block_states", e);
            }
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            Component message = messageHandler.formatText("neruina.ticking.block_state", instance.m_60734_().m_49954_().getString(), messageHandler.posAsNums(pos));
            Neruina.LOGGER.warn("Neruina Caught An Exception, see below for cause", e);
            this.addErrored(instance, pos);
            TickingEntry tickingEntry = new TickingEntry(instance, true, (ResourceKey<Level>)world.m_46472_(), pos, e);
            this.trackError(tickingEntry);
            messageHandler.broadcastToPlayers(world.m_7654_(), message, messageHandler.generateHandlingActions(ErroredType.BLOCK_STATE, (ResourceKey<Level>)world.m_46472_(), pos), messageHandler.generateResourceActions(tickingEntry));
        }
    }

    public void safelyTickBlockEntity(BlockEntityTicker<? extends BlockEntity> instance, Level world, BlockPos pos, BlockState state, BlockEntity blockEntity, Operation<Void> original) {
        block5: {
            try {
                if (this.isErrored(blockEntity)) {
                    if (world.m_5776_()) {
                        return;
                    }
                    LevelChunk chunk = world.m_46745_(pos);
                    ((WorldChunkAccessor)chunk).invokeRemoveBlockEntityTicker(pos);
                    return;
                }
                original.call(new Object[]{instance, world, pos, state, blockEntity});
            }
            catch (Throwable e) {
                if (!Config.getInstance().handleTickingBlockEntities.booleanValue()) {
                    throw TickingException.notHandled("handle_ticking_block_entities", e);
                }
                MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
                Component message = messageHandler.formatText("neruina.ticking.block_entity", state.m_60734_().m_49954_().getString(), messageHandler.posAsNums(pos));
                Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
                this.addErrored(blockEntity);
                if (world.m_5776_()) break block5;
                TickingEntry tickingEntry = new TickingEntry(blockEntity, true, (ResourceKey<Level>)world.m_46472_(), pos, e);
                this.trackError((Errorable)blockEntity, tickingEntry);
                messageHandler.broadcastToPlayers(world.m_7654_(), message, messageHandler.generateHandlingActions(ErroredType.BLOCK_ENTITY, (ResourceKey<Level>)world.m_46472_(), pos), messageHandler.generateResourceActions(tickingEntry));
            }
        }
    }

    private void handleTickingItemStack(Throwable e, ItemStack instance, boolean isServer, Player player, int slot) {
        if (!Config.getInstance().handleTickingItemStacks.booleanValue()) {
            throw TickingException.notHandled("handle_ticking_item_stacks", e);
        }
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        this.addErrored(instance);
        if (isServer) {
            TickingEntry tickingEntry = new TickingEntry(instance, false, (ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20183_(), e);
            this.trackError((Errorable)instance, tickingEntry);
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            messageHandler.sendToPlayer(player, VersionedText.translatable("neruina.ticking.item_stack", instance.m_41786_().getString(), slot), messageHandler.generateResumeAction(ErroredType.ITEM_STACK, player.m_20149_()), messageHandler.generateResourceActions(tickingEntry));
        }
    }

    private void handleErroredEntity(Entity entity) {
        try {
            if (entity instanceof Player) {
                return;
            }
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            entity.m_6075_();
            if (Config.getInstance().autoKillTickingEntities.booleanValue() || !entity.m_6084_()) {
                this.killEntity(entity, null);
            }
        }
        catch (Throwable e) {
            try {
                this.killEntity(entity, Neruina.getInstance().getMessageHandler().formatText("neruina.ticking.entity.suspend_failed", entity.m_7755_().getString()));
            }
            catch (Throwable ex) {
                throw new TickingException("Exception occurred while handling errored entity", ex);
            }
        }
    }

    public void killEntity(Entity entity, @Nullable Component withMessage) {
        entity.m_6074_();
        entity.m_142687_(Entity.RemovalReason.KILLED);
        this.removeErrored(entity);
        if (withMessage != null) {
            Neruina.getInstance().getMessageHandler().broadcastToPlayers(entity.m_20194_(), withMessage);
        }
    }

    private void handleTickingEntity(Entity entity, Throwable e) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.handleTickingPlayer(serverPlayer, e);
            } else {
                this.handleTickingClient(player, e);
            }
            return;
        }
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        this.addErrored(entity);
        Level world = entity.m_9236_();
        if (!world.m_5776_()) {
            BlockPos pos = entity.m_20183_();
            TickingEntry tickingEntry = new TickingEntry(entity, true, (ResourceKey<Level>)world.m_46472_(), pos, e);
            this.trackError((Errorable)entity, tickingEntry);
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            Component message = messageHandler.formatText("neruina.ticking.entity.%s".formatted(Config.getInstance().autoKillTickingEntities != false ? "killed" : "suspended"), entity.m_7755_().getString(), messageHandler.posAsNums(pos));
            Component actions = messageHandler.generateResourceActions(tickingEntry);
            if (!Config.getInstance().autoKillTickingEntities.booleanValue()) {
                actions = VersionedText.concatDelimited(VersionedText.LINE_BREAK, messageHandler.generateEntityActions(entity), actions);
            }
            messageHandler.broadcastToPlayers(entity.m_20194_(), message, actions);
        }
    }

    private void handleTickingPlayer(ServerPlayer player, Throwable e) {
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        MinecraftServer server = player.m_20194_();
        String name = player.m_5446_() == null ? player.m_7755_().getString() : player.m_5446_().getString();
        MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
        Component message = messageHandler.formatText("neruina.ticking.player", name);
        TickingEntry tickingEntry = new TickingEntry(player, false, (ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20183_(), e);
        this.trackError(tickingEntry);
        messageHandler.broadcastToPlayers(server, message, messageHandler.generateResourceActions(tickingEntry));
        try {
            player.f_8906_.m_9942_(VersionedText.concat(VersionedText.translatable("neruina.kick.message", new Object[0]), VersionedText.translatable("neruina.kick.reason", new Object[0])));
        }
        catch (NullPointerException ex) {
            Neruina.LOGGER.error("Neruina caught an exception on a player, but the player is not connected, this should not happen. Behaviour is undefined.", (Throwable)ex);
        }
    }

    private void handleTickingClient(Player player, Throwable e) {
        if (player.m_9236_().m_5776_() || Platform.isClient()) {
            ClientTickHandler.handleTickingClient(player, e);
        } else {
            Neruina.LOGGER.error("Neruina caught an exception, but the player is not a server player, this should not happen. Behaviour is undefined.", e);
        }
    }

    private void trackError(TickingEntry entry) {
        this.trackError(null, entry);
    }

    private void trackError(@Nullable Errorable errorable, TickingEntry entry) {
        this.recentErrors.add(entry);
        this.addTickingEntry(entry);
        if (errorable != null) {
            errorable.neruina$setTickingEntryId(entry.uuid());
        }
        if (Config.getInstance().tickingExceptionThreshold != -1 && this.recentErrors.size() >= Config.getInstance().tickingExceptionThreshold) {
            CrashReport report = CrashReport.m_127521_((Throwable)new RuntimeException("Too Many Ticking Exceptions"), (String)"Neruina has caught too many ticking exceptions in a short period of time, something is very wrong, see below for more info");
            CrashReportCategory header = report.m_127514_("Information");
            header.m_128159_("Threshold", (Object)"%d, set \"ticking_exception_threshold\" to -1 to disable.".formatted(Config.getInstance().tickingExceptionThreshold));
            header.m_128159_("Caught", (Object)this.recentErrors.size());
            String wiki = "https://github.com/Bawnorton/Neruina/wiki/Too-Many-Ticking-Exceptions";
            String lines = "=".repeat(wiki.length() + "Wiki".length() + 2);
            header.m_128159_("", (Object)lines);
            header.m_128159_("Wiki", (Object)wiki);
            header.m_128159_("", (Object)lines);
            for (int i = 0; i < this.recentErrors.size(); ++i) {
                TickingEntry error = this.recentErrors.get(i);
                CrashReportCategory section = report.m_127514_("Ticking Exception #%s - (%s: %s)".formatted(i + 1, error.getCauseType(), error.getCauseName()));
                error.populate(section);
            }
            throw new ReportedException(report);
        }
    }

    public boolean isErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            return errorable.neruina$isErrored();
        }
        return false;
    }

    public boolean isErrored(BlockState state, BlockPos pos) {
        return this.erroredBlockStates.contains(state, pos);
    }

    private void addErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            errorable.neruina$setErrored();
        }
    }

    private void addErrored(BlockState state, BlockPos pos) {
        this.erroredBlockStates.put(state, pos);
    }

    public void removeErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            errorable.neruina$clearErrored();
            this.tickingEntries.remove(errorable.neruina$getTickingEntryId());
        }
    }

    public void removeErrored(BlockState state, BlockPos pos) {
        this.erroredBlockStates.remove(state, pos);
    }

    @Nullable
    public TickingEntry getTickingEntry(UUID uuid) {
        return this.tickingEntries.get(uuid);
    }

    public Collection<TickingEntry> getTickingEntries() {
        return this.tickingEntries.values();
    }

    public void addTickingEntry(TickingEntry entry) {
        Object cause = entry.getCause();
        boolean shouldAdd = false;
        if (this.isErrored(cause)) {
            shouldAdd = true;
        } else if (cause instanceof BlockState) {
            BlockState state = (BlockState)cause;
            shouldAdd = this.isErrored(state, entry.pos());
        }
        if (shouldAdd) {
            this.tickingEntries.put(entry.uuid(), entry);
        }
    }

    public void addTickingEntryUnsafe(TickingEntry entry) {
        this.tickingEntries.put(entry.uuid(), entry);
    }

    public Optional<UUID> getTickingEntryId(Object obj) {
        Errorable errorable;
        if (obj instanceof Errorable && (errorable = (Errorable)obj).neruina$isErrored()) {
            return Optional.ofNullable(errorable.neruina$getTickingEntryId());
        }
        return Optional.empty();
    }

    public int clearTracked() {
        int size = this.tickingEntries.size();
        this.tickingEntries.clear();
        this.recentErrors.clear();
        return size;
    }
}

