/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.stamina.OtherStamina;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncStaminaToClientMessage {
    private static int syncCooldownTick = 0;
    private final Map<UUID, SynchronizedState> idAndStateMap;

    public static void requestSync(ServerPlayer player) {
        IStamina stamina = IStamina.get((Player)player);
        if (!(stamina instanceof OtherStamina)) {
            return;
        }
        SyncStaminaToClientMessage.requestSync(player, (OtherStamina)stamina);
    }

    public static void requestSync(ServerPlayer player, OtherStamina stamina) {
        SyncStaminaToClientMessage.requestSync(player.m_20148_(), stamina);
    }

    public static void requestSync(UUID playerID, OtherStamina stamina) {
        SynchronizeRequestRegistry.getInstance().add(playerID, SynchronizedState.create(stamina));
    }

    public static void tick() {
        if (syncCooldownTick > 0) {
            --syncCooldownTick;
        } else if (SynchronizeRequestRegistry.getInstance().isNotEmpty()) {
            syncCooldownTick = 10;
            SyncStaminaToClientMessage message = new SyncStaminaToClientMessage(SynchronizeRequestRegistry.getInstance().getAndClearRequestedStates());
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)message);
        }
    }

    private SyncStaminaToClientMessage(Map<UUID, SynchronizedState> stateMap) {
        this.idAndStateMap = stateMap;
    }

    public void encode(FriendlyByteBuf packet) {
        this.idAndStateMap.forEach((id, state) -> {
            packet.writeLong(id.getMostSignificantBits());
            packet.writeLong(id.getLeastSignificantBits());
            state.encode(packet);
        });
    }

    public static SyncStaminaToClientMessage decode(FriendlyByteBuf packet) {
        TreeMap<UUID, SynchronizedState> map = new TreeMap<UUID, SynchronizedState>();
        while (packet.isReadable()) {
            map.put(new UUID(packet.readLong(), packet.readLong()), SynchronizedState.load(packet));
        }
        return new SyncStaminaToClientMessage(map);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            this.idAndStateMap.forEach((arg_0, arg_1) -> SyncStaminaToClientMessage.lambda$handleClient$1((Level)world, arg_0, arg_1));
        });
        contextSupplier.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handleClient$1(Level world, UUID id, SynchronizedState state) {
        Player player = world.m_46003_(id);
        if (player == null) {
            return;
        }
        if (player.m_7578_()) {
            return;
        }
        IStamina stamina = IStamina.get(player);
        if (!(stamina instanceof OtherStamina)) {
            return;
        }
        state.apply((OtherStamina)stamina);
    }

    private static class SynchronizeRequestRegistry {
        @Nullable
        private static SynchronizeRequestRegistry instance = null;
        @Nonnull
        private TreeMap<UUID, SynchronizedState> idAndStateMap = new TreeMap();

        private SynchronizeRequestRegistry() {
        }

        public static SynchronizeRequestRegistry getInstance() {
            if (instance == null) {
                instance = new SynchronizeRequestRegistry();
            }
            return instance;
        }

        public void add(UUID playerID, SynchronizedState state) {
            this.idAndStateMap.put(playerID, state);
        }

        public boolean isNotEmpty() {
            return !this.idAndStateMap.isEmpty();
        }

        public TreeMap<UUID, SynchronizedState> getAndClearRequestedStates() {
            TreeMap<UUID, SynchronizedState> map = this.idAndStateMap;
            this.idAndStateMap = new TreeMap();
            return map;
        }
    }

    private static class SynchronizedState {
        private int staminaValue = 0;
        private int maxValue = 0;
        private boolean exhausted = false;
        private boolean imposingPenalty = false;

        public SynchronizedState(int staminaValue, int maxValue, boolean exhausted, boolean imposingPenalty) {
            this.staminaValue = staminaValue;
            this.maxValue = maxValue;
            this.exhausted = exhausted;
            this.imposingPenalty = imposingPenalty;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.staminaValue);
            buffer.writeInt(this.maxValue);
            buffer.writeBoolean(this.exhausted);
            buffer.writeBoolean(this.imposingPenalty);
        }

        public static SynchronizedState load(FriendlyByteBuf buffer) {
            return new SynchronizedState(buffer.readInt(), buffer.readInt(), buffer.readBoolean(), buffer.readBoolean());
        }

        public static SynchronizedState create(OtherStamina stamina) {
            return new SynchronizedState(stamina.get(), stamina.getActualMaxStamina(), stamina.isExhausted(), stamina.isImposingExhaustionPenalty());
        }

        public void apply(OtherStamina stamina) {
            stamina.setMax(this.maxValue);
            stamina.set(this.staminaValue);
            stamina.setImposingPenalty(this.imposingPenalty);
            stamina.setExhaustion(this.exhausted);
        }
    }
}

