/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.crops.CropLikeRegistry;
import dev.ftb.mods.ftbultimine.crops.VanillaCropLikeHandler;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.utils.PlatformMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class FTBUltiminePlayerData {
    private final UUID playerId;
    private boolean pressed = false;
    private int shapeIndex = 0;
    private double pendingXPCost;
    private BlockPos cachedPos;
    private Direction cachedDirection;
    private List<BlockPos> cachedBlocks;

    public FTBUltiminePlayerData(UUID playerId) {
        this.playerId = playerId;
    }

    public void clearCache() {
        this.cachedPos = null;
        this.cachedDirection = null;
        this.cachedBlocks = null;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean hasCachedPositions() {
        return this.cachedBlocks != null && !this.cachedBlocks.isEmpty();
    }

    public Collection<BlockPos> cachedPositions() {
        return this.cachedBlocks;
    }

    public static HitResult rayTrace(ServerPlayer player) {
        double distance = PlatformMethods.reach(player);
        return player.m_19907_(player.m_7500_() ? distance + 0.5 : distance, 1.0f, false);
    }

    public Shape getCurrentShape() {
        return ShapeRegistry.getShape(this.shapeIndex);
    }

    public int getCurrentShapeIndex() {
        return this.shapeIndex;
    }

    public void cycleShape(boolean next) {
        if (next) {
            if (++this.shapeIndex >= ShapeRegistry.shapeCount()) {
                this.shapeIndex = 0;
            }
        } else if (--this.shapeIndex < 0) {
            this.shapeIndex = ShapeRegistry.shapeCount() - 1;
        }
    }

    public void addPendingXPCost(int blockCount) {
        this.pendingXPCost += (double)blockCount * (Double)FTBUltimineServerConfig.EXPERIENCE_PER_BLOCK.get();
    }

    public void takePendingXP(ServerPlayer player) {
        if (this.pendingXPCost > 1.0) {
            int toTake = (int)this.pendingXPCost;
            String cmd = String.format("experience add @s -%d points", toTake);
            CommandSourceStack source = player.m_20203_().m_81324_();
            player.m_20194_().m_129892_().m_230957_(source, cmd);
            this.pendingXPCost -= (double)toTake;
        }
    }

    public void checkBlocks(ServerPlayer player, boolean sendUpdate, int maxBlocks) {
        BlockHitResult hitResult;
        block8: {
            block7: {
                if (!this.pressed) {
                    return;
                }
                HitResult result = FTBUltiminePlayerData.rayTrace(player);
                if (!(result instanceof BlockHitResult)) break block7;
                hitResult = (BlockHitResult)result;
                if (result.m_6662_() == HitResult.Type.BLOCK) break block8;
            }
            if (this.cachedBlocks != null && !this.cachedBlocks.isEmpty()) {
                this.clearCache();
                if (sendUpdate) {
                    new SendShapePacket(this.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
                }
            }
            return;
        }
        if (this.cachedDirection != hitResult.m_82434_() || this.cachedPos == null || !this.cachedPos.equals((Object)hitResult.m_82425_())) {
            this.updateBlocks(player, hitResult.m_82425_(), hitResult.m_82434_(), sendUpdate, maxBlocks);
        }
    }

    @Nullable
    public ShapeContext updateBlocks(ServerPlayer player, BlockPos pos, Direction dir, boolean sendUpdate, int maxBlocks) {
        ShapeContext context = null;
        this.cachedPos = pos.m_7949_();
        this.cachedDirection = dir;
        Shape shape = this.getCurrentShape();
        if (maxBlocks <= 0) {
            this.cachedBlocks = Collections.emptyList();
        } else {
            int max;
            BlockState origState = player.m_9236_().m_8055_(this.cachedPos);
            BlockMatcher matcher = shape.getTagMatcher().actualCheck(origState, origState) ? shape.getTagMatcher() : (VanillaCropLikeHandler.looksLikeACrop(origState) || CropLikeRegistry.getInstance().getHandlerFor(player.m_9236_(), pos, origState).isPresent() ? BlockMatcher.CROP_LIKE : BlockMatcher.MATCH);
            context = new ShapeContext(player, this.cachedPos, this.cachedDirection, player.m_9236_().m_8055_(this.cachedPos), matcher, maxBlocks);
            this.cachedBlocks = shape.getBlocks(context);
            if ((Double)FTBUltimineServerConfig.EXPERIENCE_PER_BLOCK.get() > 0.0 && (max = (int)((double)player.f_36079_ / (Double)FTBUltimineServerConfig.EXPERIENCE_PER_BLOCK.get())) < this.cachedBlocks.size()) {
                this.cachedBlocks = this.cachedBlocks.subList(0, max);
            }
        }
        if (sendUpdate) {
            new SendShapePacket(this.getCurrentShapeIndex(), this.cachedBlocks).sendTo(player);
        }
        return context;
    }
}

