/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.companions.config.CompanionsConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CompanionsAddItemModifier
extends LootModifier {
    public static final Supplier<Codec<CompanionsAddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> CompanionsAddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(mod -> mod.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(mod -> Float.valueOf(mod.chance))).apply((Applicative)inst, CompanionsAddItemModifier::new)));
    private final Item item;
    private final float chance;

    public CompanionsAddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        if ((double)context.m_230907_().m_188501_() <= CompanionsConfig.DEMON_FLESH_DROP_RATE) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

