/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.util;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.mixin.CompanionsLevelAccessor;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Util {
    private Util() {
    }

    public static BlockPos findClosestGroundBelow(CompanionEntity entity, float y) {
        Vec3 start = new Vec3(entity.m_20185_(), entity.m_20191_().f_82289_ + 0.01, entity.m_20189_());
        BlockHitResult trace = entity.m_9236_().m_45547_(new ClipContext(start, start.m_82492_(0.0, (double)y, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (trace.m_6662_() == HitResult.Type.BLOCK) {
            return trace.m_82425_();
        }
        return null;
    }

    public static float normalizeDeg(float deg) {
        return (deg %= 360.0f) < 0.0f ? deg + 360.0f : deg;
    }

    public static float degToRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static Vec3 bezier(Vec3 a, Vec3 b, Vec3 c, double t) {
        double u = 1.0 - t;
        double tt = t * t;
        double uu = u * u;
        return new Vec3(uu * a.f_82479_ + 2.0 * u * t * b.f_82479_ + tt * c.f_82479_, uu * a.f_82480_ + 2.0 * u * t * b.f_82480_ + tt * c.f_82480_, uu * a.f_82481_ + 2.0 * u * t * b.f_82481_ + tt * c.f_82481_);
    }

    public static double estimateLengthBezier(Vec3 a, Vec3 b, Vec3 c) {
        double len = 0.0;
        Vec3 prev = a;
        for (int i = 1; i <= 24; ++i) {
            double t = (double)i / 24.0;
            Vec3 cur = Util.bezier(a, b, c, t);
            len += cur.m_82554_(prev);
            prev = cur;
        }
        return len;
    }

    public static Vec3 rotateHorizontalDirection(Vec3 direction, double degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new Vec3(direction.f_82479_ * cos - direction.f_82481_ * sin, direction.f_82480_, direction.f_82479_ * sin + direction.f_82481_ * cos);
    }

    public static BlockPos findValidSpawnPos(BlockPos pos, Level level) {
        if (Util.isValidSpawnPos(pos, level)) {
            return pos;
        }
        for (int d = 1; d <= 6; ++d) {
            BlockPos below = pos.m_6625_(d);
            if (!Util.isValidSpawnPos(below, level)) continue;
            return below;
        }
        for (int u = 1; u <= 3; ++u) {
            BlockPos above = pos.m_6630_(u);
            if (!Util.isValidSpawnPos(above, level)) continue;
            return above;
        }
        return pos;
    }

    private static boolean isValidSpawnPos(BlockPos pos, Level level) {
        return level.m_46739_(pos) && level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    public static boolean areEntitiesLinked(Entity e1, Entity e2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1 == e2) {
            return true;
        }
        Set<UUID> ownersA = Util.collectOwners(e1, new HashSet<UUID>(), new HashSet<UUID>());
        Set<UUID> ownersB = Util.collectOwners(e2, new HashSet<UUID>(), new HashSet<UUID>());
        ownersA.retainAll(ownersB);
        return !ownersA.isEmpty();
    }

    private static Set<UUID> collectOwners(Entity current, Set<UUID> result, Set<UUID> visited) {
        OwnableEntity owE;
        UUID ownerUuid;
        if (current == null) {
            return result;
        }
        if (!visited.add(current.m_20148_())) {
            return result;
        }
        result.add(current.m_20148_());
        if (current instanceof TamableAnimal) {
            CompanionSummonEntity summon;
            UUID secondUuid;
            TamableAnimal tamable = (TamableAnimal)current;
            ownerUuid = tamable.m_21805_();
            if (ownerUuid != null) {
                result.add(ownerUuid);
            }
            if (current instanceof CompanionSummonEntity && (secondUuid = (summon = (CompanionSummonEntity)current).getSecondOwnerUUID()) != null) {
                result.add(secondUuid);
            }
            Util.collectOwners((Entity)tamable.m_269323_(), result, visited);
        }
        if (current instanceof Projectile) {
            Projectile projectile = (Projectile)current;
            Util.collectOwners(projectile.m_19749_(), result, visited);
        }
        if (current instanceof OwnableEntity && (ownerUuid = (owE = (OwnableEntity)current).m_21805_()) != null) {
            Level level;
            result.add(ownerUuid);
            Player owner = current.m_9236_().m_46003_(ownerUuid);
            if (owner == null && (level = current.m_9236_()) instanceof CompanionsLevelAccessor) {
                CompanionsLevelAccessor acc = (CompanionsLevelAccessor)level;
                owner = (Entity)acc.companions$getEntities().m_142694_(ownerUuid);
            }
            Util.collectOwners((Entity)owner, result, visited);
        }
        return result;
    }

    public static Vec3 randomVectorInCone(Vec3 base, double maxAngleDegrees, Random random) {
        Vec3 baseNorm = base.m_82541_();
        Vec3 u = baseNorm.m_82537_(new Vec3(0.0, 1.0, 0.0));
        if (u.m_82556_() < 1.0E-6) {
            u = baseNorm.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        u = u.m_82541_();
        Vec3 v = baseNorm.m_82537_(u).m_82541_();
        double minCos = Math.cos(Math.toRadians(maxAngleDegrees));
        double cos = minCos + random.nextDouble() * (1.0 - minCos);
        double sin = Math.sqrt(1.0 - cos * cos);
        double phi = random.nextDouble() * 2.0 * Math.PI;
        return baseNorm.m_82490_(cos).m_82549_(u.m_82490_(sin * Math.cos(phi))).m_82549_(v.m_82490_(sin * Math.sin(phi))).m_82490_(base.m_82553_());
    }

    public static int hasFullSetOn(Player player, ArmorMaterials material) {
        int amount = 0;
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            ArmorItem armorItem;
            Item item;
            if (armorStack.m_41619_() || !((item = armorStack.m_41720_()) instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != material) continue;
            ++amount;
        }
        return amount;
    }

    public static ListTag floatsToList(float[] arr) {
        ListTag list = new ListTag();
        for (float v : arr) {
            list.add((Object)FloatTag.m_128566_((float)v));
        }
        return list;
    }

    public static ListTag intsToList(int[] arr) {
        ListTag list = new ListTag();
        for (int v : arr) {
            list.add((Object)IntTag.m_128679_((int)v));
        }
        return list;
    }

    public static void listToFloats(ListTag list, float[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((FloatTag)list.get(i)).m_7057_();
        }
    }

    public static void listToInts(ListTag list, int[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((IntTag)list.get(i)).m_7047_();
        }
    }
}

