/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.item.TooltipItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MutantFlesh
extends TooltipItem {
    public MutantFlesh(Item.Properties properties, String tooltipName) {
        super(properties, tooltipName);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        ItemStack ret = super.m_5922_(stack, level, entity);
        if (entity instanceof Player) {
            AABB bb;
            Vec3 endPos;
            Vec3 eyePos;
            EntityHitResult entityHit;
            Player player = (Player)entity;
            if (!level.f_46443_ && (entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)(eyePos = entity.m_146892_()), (Vec3)(endPos = eyePos.m_82549_(entity.m_20154_().m_82490_(20.0))), (AABB)(bb = new AABB(eyePos, endPos).m_82400_(2.0)), Entity::m_6084_)) != null && CompanionsConfig.MUTANT_FLESH_SHOULD_TP) {
                this.spawnMutantParticles(10, level, player.m_20182_());
                Vec3 tpPos = this.calculateOppositeSide((LivingEntity)player, entityHit.m_82443_());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_6021_(tpPos.f_82479_, tpPos.f_82480_, tpPos.f_82481_);
                } else {
                    player.m_6034_(tpPos.f_82479_, tpPos.f_82480_, tpPos.f_82481_);
                }
                this.spawnMutantParticles(10, level, tpPos);
            }
        }
        if (level.f_46441_.m_188501_() < 0.25f) {
            entity.m_7292_(new MobEffectInstance(CompanionsEffects.VOODOO.get(), level.f_46441_.m_216339_(100, 600), 0, true, true, true));
        }
        if ((double)level.f_46441_.m_188501_() < 0.75 && CompanionsConfig.MUTANT_FLESH_SHOULD_HURT) {
            entity.m_6469_(entity.m_269291_().m_269425_(), 3.0f);
        }
        return ret;
    }

    private void spawnMutantParticles(int amount, Level level, Vec3 position) {
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (int i = 0; i < amount; ++i) {
                double dx = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                double dy = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                double dz = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                sv.m_8767_((ParticleOptions)ParticleTypes.f_123759_, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, 1, dx, dy, dz, 0.1);
                if (i % 5 != 0) continue;
                sv.m_8767_((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION.get(), position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, 1, dx, dy, dz, 0.2);
            }
        }
    }

    private Vec3 calculateOppositeSide(LivingEntity player, Entity target) {
        Vec3 playerPos = player.m_20182_();
        Vec3 targetPos = target.m_20182_();
        Vec3 oppositePos = targetPos.m_82549_(targetPos.m_82546_(playerPos));
        return new Vec3(oppositePos.f_82479_, playerPos.f_82480_, oppositePos.f_82481_);
    }
}

