/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.projectile.HolinessNaginataProjectile;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NeedleProjectile
extends HolinessNaginataProjectile
implements GeoEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(NeedleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public NeedleProjectile(EntityType<? extends ThrownTrident> type, Level level) {
        super(type, level);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        if (!this.m_9236_().f_46443_) {
            this.timeToDespawn = new Random().nextInt(80, 160);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        for (int i = 0; i < 8; ++i) {
            double vx = (this.m_9236_().f_46441_.m_188500_() - 0.5) * (double)this.m_20205_();
            double vy = (this.m_9236_().f_46441_.m_188500_() - 0.5) * (double)this.m_20206_();
            double vz = (this.m_9236_().f_46441_.m_188500_() - 0.5) * (double)this.m_20205_();
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, vx, vy, vz, 0.15);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getLifetime() >= this.timeToDespawn) {
                this.m_146870_();
            }
            this.setLifetime(this.getLifetime() + 1);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        entity.m_6469_(damageSource, (float)CompanionsConfig.NEEDLE_PROJECTILE_DAMAGE);
        this.m_5496_(SoundEvents.f_12514_, 5.0f, 1.0f);
    }

    @Override
    protected void doShake() {
        if (this.m_9236_().f_46443_) {
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(30.0))) {
                Companions.PROXY.shakePlayerCamera(player, 5, 0.02f, 0.02f, 0.02f, 10);
            }
        }
    }

    public int getLifetime() {
        return (Integer)this.f_19804_.m_135370_(LIFETIME);
    }

    public void setLifetime(int tick) {
        this.f_19804_.m_135381_(LIFETIME, (Object)tick);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Lifetime", this.getLifetime());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Lifetime")) {
            this.setLifetime(pCompound.m_128451_("Lifetime"));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LIFETIME, (Object)80);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoEntity> PlayState predicate(AnimationState<T> state) {
        state.setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    @Override
    @NotNull
    public AABB m_6921_() {
        return super.m_6921_().m_82400_(10.0);
    }
}

