/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BloodTornadoProjectile
extends BaseProjectile {
    private final RawAnimation SPIN = RawAnimation.begin().thenPlay("spin");
    private static final EntityDataAccessor<Float> GROUNDY = SynchedEntityData.m_135353_(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STARTX = SynchedEntityData.m_135353_(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STARTZ = SynchedEntityData.m_135353_(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.m_135353_(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> TICKS = SynchedEntityData.m_135353_(BloodTornadoProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean initialized = false;

    public BloodTornadoProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GROUNDY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STARTX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STARTZ, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TICKS, (Object)0);
        this.f_19804_.m_135372_(ALPHA, (Object)Float.valueOf(Float.NaN));
    }

    public float getGroundY() {
        return ((Float)this.f_19804_.m_135370_(GROUNDY)).floatValue();
    }

    public void setGroundY(float v) {
        this.f_19804_.m_135381_(GROUNDY, (Object)Float.valueOf(v));
    }

    public float getStartX() {
        return ((Float)this.f_19804_.m_135370_(STARTX)).floatValue();
    }

    public void setStartX(float v) {
        this.f_19804_.m_135381_(STARTX, (Object)Float.valueOf(v));
    }

    public float getStartZ() {
        return ((Float)this.f_19804_.m_135370_(STARTZ)).floatValue();
    }

    public void setStartZ(float v) {
        this.f_19804_.m_135381_(STARTZ, (Object)Float.valueOf(v));
    }

    public float getAlpha() {
        return ((Float)this.f_19804_.m_135370_(ALPHA)).floatValue();
    }

    public void setAlpha(float v) {
        this.f_19804_.m_135381_(ALPHA, (Object)Float.valueOf(v));
    }

    public int getTicks() {
        return (Integer)this.f_19804_.m_135370_(TICKS);
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(TICKS, (Object)this.f_19797_);
        }
        super.m_8119_();
        if (!this.initialized) {
            this.setGroundY((float)this.m_20186_());
            this.setStartX((float)this.m_20185_());
            this.setStartZ((float)this.m_20189_());
            if (Float.isNaN(this.getAlpha())) {
                Vec3 dir = this.m_20184_().m_82541_();
                this.setAlpha((float)Math.atan2(dir.f_82481_, dir.f_82479_));
            }
            this.m_20242_(true);
            this.initialized = true;
        }
        double t = (double)this.getTicks() * 0.2;
        double xLocal = 2.0 * Math.sin(1.5707963267948966 * t);
        double zLocal = t;
        double cosA = Math.cos(this.getAlpha());
        double sinA = Math.sin(this.getAlpha());
        this.m_6034_((double)this.getStartX() + (xLocal * cosA - zLocal * sinA), this.getGroundY(), (double)this.getStartZ() + (xLocal * sinA + zLocal * cosA));
        this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82400_(1.0), e -> !Util.areEntitiesLinked((Entity)this, e)).forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.m_6469_(this.m_269291_().m_269425_(), (float)CompanionsConfig.BLOOD_TORNADO_DAMAGE);
            }
        });
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            Random random = new Random();
            if ((double)random.nextFloat() <= 0.15) {
                sv.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.m_20185_() + (double)(this.m_20205_() * 2.0f) * Math.random(), this.m_20186_() + (double)(this.m_20206_() * 2.0f) * Math.random(), this.m_20189_() + (double)(this.m_20205_() * 2.0f) * Math.random(), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        if (this.m_9236_().f_46443_ && (this.f_19797_ % 35 == 0 || this.f_19797_ == 1)) {
            for (int i = 0; i < 3; ++i) {
                Companions.PROXY.spawnBaseProjectileTrail((Entity)this, this.m_20206_() - 0.25f, this.m_20206_(), 0.5294118f, 0.0f, 0.0f);
            }
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        if (!this.m_9236_().f_46443_) {
            this.spawnRemoveParticles();
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_144245_, SoundSource.NEUTRAL);
        }
        super.m_142687_(pReason);
    }

    private void spawnRemoveParticles() {
        for (int i = 0; i < 15; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.15;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.15;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.15;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
            if (!(level2.f_46441_.m_188501_() < 0.35f)) continue;
            level2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1225);
        }
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_6123_(@NotNull Player pEntity) {
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    @Override
    protected int baseLifetime() {
        return 120;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.SPIN);
        return PlayState.CONTINUE;
    }
}

