/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BlackHoleProjectile
extends BaseProjectile {
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.m_135353_(BlackHoleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKCOUNT = SynchedEntityData.m_135353_(BlackHoleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double ATTRACT_RADIUS = CompanionsConfig.BLACK_HOLE_ATTRACTION_RADIUS;
    private static final float GRAVITY = 0.03f;

    public BlackHoleProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_LOCKED, (Object)false);
        this.f_19804_.m_135372_(TICKCOUNT, (Object)0);
    }

    public boolean isLocked() {
        return (Boolean)this.f_19804_.m_135370_(IS_LOCKED);
    }

    public void setLocked(boolean locked) {
        this.f_19804_.m_135381_(IS_LOCKED, (Object)locked);
    }

    public int getTickCount() {
        return (Integer)this.f_19804_.m_135370_(TICKCOUNT);
    }

    public void setTickCount(int tickCount) {
        this.f_19804_.m_135381_(TICKCOUNT, (Object)tickCount);
    }

    private void updateRotation(Vec3 vel) {
        double horizontalMag = vel.m_165924_();
        float newYaw = (float)(Mth.m_14136_((double)vel.f_82479_, (double)vel.f_82481_) * 57.29577951308232);
        float newPitch = (float)(Mth.m_14136_((double)vel.f_82480_, (double)horizontalMag) * 57.29577951308232);
        this.m_146922_(BlackHoleProjectile.m_37273_((float)this.m_146908_(), (float)newYaw));
        this.m_146926_(BlackHoleProjectile.m_37273_((float)this.m_146909_(), (float)newPitch));
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            this.setTickCount(this.f_19797_);
        }
        super.m_8119_();
        if (this.getTickCount() == 20) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), CompanionsSounds.SPELL_RELEASE_SPEARS.get(), this.m_5720_(), 1.5f, 1.0f);
        }
        Random random = new Random();
        if ((double)random.nextFloat() < 0.44 && this.getTickCount() < this.getLifetime() - 20) {
            for (int i = 0; i < 1; ++i) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                double x = (Math.random() - 0.5) * 0.5;
                double z = (Math.random() - 0.5) * 0.5;
                level2.m_8767_((ParticleOptions)CompanionsParticles.BLACK_HOLE_STAR.get(), this.m_20185_() + x, this.m_20186_() - 0.2, this.m_20189_() + z, 1, (Math.random() - 0.5) * 0.1, 0.0, (Math.random() - 0.5) * 0.1, 0.2);
            }
        }
        if (this.getTickCount() >= this.getLifetime()) {
            this.m_146870_();
            return;
        }
        if (this.isLocked()) {
            if (this.m_9236_().f_46443_) {
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(30.0))) {
                    Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
                }
            }
            this.m_20256_(Vec3.f_82478_);
            this.attractNearbyEntities();
            return;
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= 20 && !this.isLocked()) {
            this.setLocked(true);
        }
        Vec3 oldPos = this.m_20182_();
        Vec3 vel = this.m_20184_();
        if (!this.f_19794_) {
            vel = vel.m_82520_(0.0, (double)-0.03f, 0.0);
        }
        vel = vel.m_82490_(0.99);
        BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(oldPos, oldPos.m_82549_(vel), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hitPos = blockHit.m_82450_();
            this.m_6034_(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_);
            this.m_20256_(Vec3.f_82478_);
            this.setLocked(true);
        } else {
            this.m_20256_(vel);
            this.m_6478_(MoverType.SELF, vel);
            this.updateRotation(vel);
            if (this.m_20096_()) {
                this.setLocked(true);
                this.m_20256_(Vec3.f_82478_);
            }
        }
        this.attractNearbyEntities();
    }

    private void attractNearbyEntities() {
        List nearby = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(ATTRACT_RADIUS), e -> !Util.areEntitiesLinked((Entity)e, (Entity)this));
        for (LivingEntity ent : nearby) {
            Vec3 toCenter = new Vec3(this.m_20185_() - ent.m_20185_(), this.m_20186_() - ent.m_20186_(), this.m_20189_() - ent.m_20189_());
            double distance = toCenter.m_82553_();
            if (distance < 0.05) continue;
            toCenter = toCenter.m_82541_();
            double linear = (ATTRACT_RADIUS - distance) / ATTRACT_RADIUS;
            if (linear < 0.0) {
                linear = 0.0;
            }
            Vec3 desiredVel = toCenter.m_82490_(Math.pow(linear, 2.0) * CompanionsConfig.BLACK_HOLE_ATTRACTION_SPEED);
            Vec3 currentVel = ent.m_20184_();
            Vec3 newVel = currentVel.m_165921_(desiredVel, 0.15);
            ent.m_20256_(newVel);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "extraController", this::extraPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    @Override
    protected int baseLifetime() {
        return 100;
    }

    private <T extends GeoAnimatable> PlayState extraPredicate(AnimationState<T> event) {
        if (this.getTickCount() >= this.getLifetime() - 7) {
            event.getController().setAnimation(DISAPPEAR);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }
}

