/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionBaseAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionBaseLongAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionNearestAttackableTarget;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WildAntlionEntity
extends HostileEntity
implements PlayerRideable {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation DIG_IN = RawAnimation.begin().thenPlay("dig");
    private final RawAnimation DIG_OUT = RawAnimation.begin().thenPlay("dig_out");
    private final RawAnimation DIG_IDLE = RawAnimation.begin().thenPlay("dig_idle");
    private final RawAnimation DIG_ATTACK = RawAnimation.begin().thenPlay("dig_attack");
    private final RawAnimation DIG_SHOOT = RawAnimation.begin().thenPlay("dig_attack2");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(WildAntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(WildAntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int ANIMATION_BASE_DIG_IN_TICKS = 55;
    private static final int ANIMATION_BASE_DIG_OUT_TICKS = 15;
    private static final int NO_TARGET_MAX_TICKS = 20;
    private int diginCounter = -1;
    private int digoutCounter = -1;
    private int noTargetCounter = -1;

    public WildAntlionEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setNoMovement(this.isUnderground() || this.getState() == 1);
            if (this.getState() == 1 && this.diginCounter == -1) {
                ++this.diginCounter;
            }
            if (this.getState() == 2 && this.noTargetCounter == -1 && this.m_5448_() == null) {
                ++this.noTargetCounter;
            } else if (this.getState() == 2 && this.noTargetCounter == -1 && this.m_5448_() == null) {
                this.noTargetCounter = -1;
            }
            if (this.diginCounter != -1) {
                ++this.diginCounter;
            }
            if (this.digoutCounter != -1) {
                ++this.digoutCounter;
            }
            if (this.noTargetCounter != -1) {
                ++this.noTargetCounter;
            }
            if (this.diginCounter == 55) {
                this.cycleState();
                this.diginCounter = -1;
            }
            if (this.noTargetCounter == 20) {
                this.cycleState();
                this.noTargetCounter = -1;
                ++this.digoutCounter;
            }
            if (this.digoutCounter == 15) {
                this.cycleState();
                this.digoutCounter = -1;
            }
            if (this.diginCounter == 20 || this.diginCounter == 35 || this.digoutCounter == 5) {
                this.earthquake();
            }
        }
    }

    private void earthquake() {
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist < 1 || dist > radius) continue;
                BlockPos blockPos = this.m_20183_().m_7918_(x, -1, z);
                BlockState state = this.m_9236_().m_8055_(blockPos);
                if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_) continue;
                if (dist == 1) {
                    this.spawnFallingBlock(blockPos, state, 0.18);
                    continue;
                }
                TickScheduler.scheduleServer((Level)this.m_9236_(), () -> this.spawnFallingBlock(blockPos, state, 0.2), (int)5);
            }
        }
    }

    private void spawnFallingBlock(BlockPos pos, BlockState state, double yDelay) {
        FallingBlockEntity block = new FallingBlockEntity(this.m_9236_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, state);
        block.m_20334_(0.0, yDelay, 0.0);
        this.m_9236_().m_7967_((Entity)block);
        this.m_9236_().m_7471_(pos, false);
    }

    public void cycleState() {
        switch (this.getState()) {
            case 0: {
                this.setState(1);
                break;
            }
            case 1: {
                this.setState(2);
                break;
            }
            case 2: {
                this.setState(3);
                break;
            }
            case 3: {
                this.setState(0);
            }
        }
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public boolean isUnderground() {
        return this.getState() == 2;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WildAntlionBaseAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(1, (Goal)new WildAntlionBaseLongAttackGoal(this, 20, 60));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.43));
        this.f_21346_.m_25352_(1, new WildAntlionNearestAttackableTarget<Player>(this, Player.class, true));
    }

    public static AttributeSupplier setAttributes() {
        return HostileEntity.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        super.m_6478_(pType, pPos);
        this.m_20101_();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.isEntityInFront((Entity)player) && player.m_21120_(hand).m_41720_() == CompanionsItems.CRYSTALLIZED_BLOOD.get()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (this.tameAntlion(player)) {
                this.tameParticles();
                this.m_146870_();
            } else {
                this.failureParticles();
            }
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.ANTLION_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.ANTLION_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.ANTLION_IDLE.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_216990_(CompanionsSounds.ANTLION_STEPS.get());
    }

    protected boolean isEntityInFront(Entity target) {
        Vec3 toTarget = new Vec3(target.m_20185_(), this.m_20186_(), target.m_20189_()).m_82546_(this.m_20182_()).m_82541_();
        double angle = Math.acos(this.m_20154_().m_82541_().m_82526_(toTarget)) * 57.29577951308232;
        return angle < 100.0;
    }

    private boolean tameAntlion(Player player) {
        if (this.m_9236_().f_46441_.m_188501_() < 0.55f) {
            AntlionEntity antlion = (AntlionEntity)((EntityType)CompanionsEntities.ANTLION.get()).m_20615_(this.m_9236_());
            if (antlion != null) {
                antlion.m_20219_(this.m_20182_());
                antlion.tameInteraction(player);
                this.m_9236_().m_7967_((Entity)antlion);
            }
            return true;
        }
        return false;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.f_46441_.m_188501_() < 0.65f) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.f_46441_.m_188501_() < 0.25f)) continue;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.2);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.f_46441_.m_188501_() < 0.65f)) continue;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.025);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.DIG_ATTACK);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.DIG_SHOOT);
        } else if (this.getState() == 1) {
            event.getController().setAnimation(this.DIG_IN);
        } else if (this.getState() == 2) {
            event.getController().setAnimation(this.DIG_IDLE);
        } else if (this.getState() == 3) {
            event.getController().setAnimation(this.DIG_OUT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

