/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.teddy.control.TeddyMoveControl;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyAttackGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyFollowTargetGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.TeddyApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.TeddyAttackGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.TeddyVoodooAttackGoal;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TeddyEntity
extends CompanionEntity
implements TraceableEntity {
    private final RawAnimation LAY = RawAnimation.begin().thenPlay("lay");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation SLEEP = RawAnimation.begin().thenPlay("sleep");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation STAB = RawAnimation.begin().thenPlay("stab");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation AUTO_STAB = RawAnimation.begin().thenPlay("auto_stab");
    private final RawAnimation TRANSFORM = RawAnimation.begin().thenPlay("transform");
    private final RawAnimation MUTATED_FLY = RawAnimation.begin().thenPlay("flying");
    private final RawAnimation MUTATED_ATTACK1 = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation MUTATED_ATTACK2 = RawAnimation.begin().thenPlay("stab");
    private final RawAnimation MUTATED_SIT1 = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation MUTATED_SIT2 = RawAnimation.begin().thenPlay("laying");
    private final RawAnimation MUTATED_SIT3 = RawAnimation.begin().thenPlay("flying_sit");
    private final RawAnimation MUTATED_DEATH = RawAnimation.begin().thenPlay("death");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SECOND_PHASE_COUNTER = SynchedEntityData.m_135353_(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ON_AIR = SynchedEntityData.m_135353_(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TELEPORTED = SynchedEntityData.m_135353_(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int ANIMATION_TRANSFORM_MAX_TICKS = 200;
    private static final int ANIMATION_DEAD_MAX_TICKS = 64;

    public TeddyEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public boolean getTeleported() {
        return (Boolean)this.f_19804_.m_135370_(TELEPORTED);
    }

    public void setTeleported(boolean teleported) {
        this.f_19804_.m_135381_(TELEPORTED, (Object)teleported);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal(this){

            public boolean m_8036_() {
                if (!TeddyEntity.this.m_21824_()) {
                    return false;
                }
                if (TeddyEntity.this.m_20072_()) {
                    return false;
                }
                if (!TeddyEntity.this.m_20096_() && TeddyEntity.this.getPhase() == 1) {
                    return false;
                }
                if (TeddyEntity.this.m_269323_() == null) {
                    return true;
                }
                return !(TeddyEntity.this.m_20280_((Entity)TeddyEntity.this.m_269323_()) < 144.0 && TeddyEntity.this.m_269323_().m_21188_() != null || !TeddyEntity.this.m_21827_());
            }

            public void m_8056_() {
                super.m_8056_();
                if (TeddyEntity.this.getPhase() == 2) {
                    double currentX = TeddyEntity.this.m_20185_();
                    double currentZ = TeddyEntity.this.m_20189_();
                    BlockPos groundPos = Util.findClosestGroundBelow(TeddyEntity.this, 3.0f);
                    if (groundPos != null) {
                        double y = (double)groundPos.m_123342_() + 1.0;
                        TeddyEntity.this.m_6021_(currentX, y, currentZ);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new TeddyAttackGoal(this, 10, 30));
        this.f_21345_.m_25352_(2, (Goal)new TeddyVoodooAttackGoal(this, 60, 200));
        this.f_21345_.m_25352_(3, (Goal)new TeddyApproachTargetGoal(this, 0.45, 0.4f, 1.25f));
        this.f_21345_.m_25352_(3, (Goal)new MutatedTeddyAttackGoal(this, 0, 15));
        this.f_21345_.m_25352_(4, (Goal)new MutatedTeddyFollowTargetGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MutatedTeddyRandomStrollGoal(this, 0.43f));
        this.f_21345_.m_25352_(5, (Goal)new MutatedTeddyFollowOwnerGoal(this, 0.6, 3.0, 7.0, 0.18f));
        this.f_21345_.m_25352_(5, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && TeddyEntity.this.getPhase() == 1;
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new CompanionRandomStrollGoal(this, 0.43){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && TeddyEntity.this.getPhase() == 1;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && TeddyEntity.this.getMainAction() != 0 && TeddyEntity.this.getPhase() == 1;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && TeddyEntity.this.getMainAction() != 0 && TeddyEntity.this.getPhase() == 1;
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getPhase() == 2 && source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        boolean ret = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && amount > 4.0f && this.getPhase() == 2 && this.m_5448_() != null) {
            this.spawnMutantParticles(25);
            this.tpOppositeSide();
            this.spawnMutantParticles(25);
        }
        return ret;
    }

    private void tpOppositeSide() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        Vec3 pos = target.m_20182_();
        Vec3 newPos = pos.m_82492_(this.m_20182_().f_82479_ - pos.f_82479_, 0.0, this.m_20182_().f_82481_ - pos.f_82481_);
        this.m_6034_(newPos.f_82479_, this.m_20182_().f_82480_, newPos.f_82481_);
        this.setTeleported(true);
    }

    public static AttributeSupplier setAttributes() {
        return CompanionEntity.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.TEDDY_MAX_LIFE).m_22268_(Attributes.f_22281_, CompanionsConfig.TEDDY_DAMAGE).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    private void updateStats() {
        AttributeInstance damage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(CompanionsConfig.TEDDY_MUTANT_MAX_LIFE);
        }
        if ((damage = this.m_21051_(Attributes.f_22281_)) != null) {
            damage.m_22100_(CompanionsConfig.TEDDY_MUTANT_DAMAGE);
        }
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public int getSecondPhaseCounter() {
        return (Integer)this.f_19804_.m_135370_(SECOND_PHASE_COUNTER);
    }

    public void setSecondPhaseCounter(int t) {
        this.f_19804_.m_135381_(SECOND_PHASE_COUNTER, (Object)t);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    public boolean getIsOnAir() {
        return (Boolean)this.f_19804_.m_135370_(IS_ON_AIR);
    }

    public void setIsOnAir(boolean isOnAir) {
        this.f_19804_.m_135381_(IS_ON_AIR, (Object)isOnAir);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return this.getPhase() != 2 && super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)1);
        this.f_19804_.m_135372_(SECOND_PHASE_COUNTER, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(IS_ON_AIR, (Object)false);
        this.f_19804_.m_135372_(TELEPORTED, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getPhase() == 2) {
            this.m_20242_(true);
        }
        if (this.getPhase() == 2 && !this.m_9236_().f_46443_ && this.getMainAction() == 0) {
            this.setIsOnAir(this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_());
        }
        if (this.getSecondPhaseCounter() != 0 && this.getSecondPhaseCounter() <= 200) {
            this.m_6710_(null);
            this.setNoMovement(true);
            if (this.getSecondPhaseCounter() == 200) {
                this.setNoMovement(false);
                this.m_9236_().m_6493_((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION_CLOUD.get(), true, this.m_20185_(), this.m_20186_() + (double)0.15f, this.m_20189_(), 0.0, 0.0, 0.0);
                this.spawnMutantParticles(50);
                this.setPhase(2);
                this.m_6210_();
                this.updateStats();
                this.m_216990_(CompanionsSounds.TEDDY_TRANSFORMATION.get());
                this.f_21342_ = new TeddyMoveControl(this);
            }
            this.setSecondPhaseCounter(this.getSecondPhaseCounter() + 1);
        }
        if (this.getPhase() == 2 && this.m_269323_() != null && !this.m_269323_().m_21023_(MobEffects.f_19605_) && this.m_20280_((Entity)this.m_269323_()) < 256.0) {
            this.m_269323_().m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0, true, true, true));
        }
        if (this.getPhase() == 2 && !this.m_9236_().f_46443_ && CompanionsConfig.TEDDY_MUTANT_HEALS_OVER_TIME) {
            if (this.f_19797_ % 200 == 0) {
                this.m_5634_(1.0f);
            }
            if (this.f_19797_ % 15 == 0 && (this.getMainAction() == 0 && this.getIsOnAir() || this.getMainAction() != 0)) {
                this.m_5496_(CompanionsSounds.MUTANT_TEDDY_FLAP_WINGS.get(), 0.4f, 1.0f);
            }
        }
    }

    private void spawnMutantParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, dx, dy, dz, 0.1);
            if (i % 5 != 0) continue;
            level2.m_8767_((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, dx, dy, dz, 0.2);
        }
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        if (this.getPhase() == 2) {
            this.m_5496_(CompanionsSounds.MUTANT_TEDDY_HURT.get(), 0.55f, 1.0f);
        }
        super.m_6677_(pSource);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.getPhase() == 2 ? CompanionsSounds.MUTANT_TEDDY_IDLE.get() : null;
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        super.m_6478_(pType, pPos);
        this.m_20101_();
    }

    @Nullable
    public LivingEntity m_269323_() {
        return super.m_269323_();
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return this.getPhase() == 1 ? super.m_6972_(pPose) : EntityDimensions.m_20395_((float)1.0f, (float)2.0f);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.getSecondPhaseCounter() != 0 && this.getPhase() == 1) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_21824_() && stack.m_41720_() == CompanionsItems.NEEDLE.get()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.tameInteraction(player);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player == this.m_269323_() && stack.m_41720_() == CompanionsItems.ETERNAL_LIGHTER.get() && this.getPhase() == 1) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.setSecondPhaseCounter(this.getSecondPhaseCounter() + 1);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player == this.m_269323_() && stack.m_41720_() == Items.f_42448_ && this.getPhase() == 2) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, new ItemStack((ItemLike)CompanionsItems.MUTANT_FLESH.get(), new Random().nextInt(1, 3))));
            this.m_216990_(SoundEvents.f_11911_);
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.getPhase() == 2) {
            if (this.f_20919_ >= 64 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.getPhase() == 1) {
            this.m_216990_(CompanionsSounds.TEDDY_STEP.get());
        } else {
            super.m_7355_(pPos, pState);
        }
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (pKey.equals(PHASE)) {
            this.m_6210_();
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Phase")) {
            this.setPhase(pCompound.m_128451_("Phase"));
            if (this.getPhase() == 2) {
                this.f_21342_ = new TeddyMoveControl(this);
            }
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Phase", this.getPhase());
        if (this.getSecondPhaseCounter() != 0) {
            pCompound.m_128405_("Phase", 2);
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return this.getPhase() == 1 ? 3 : 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.TEDDY_KEEP_CHUNK_LOADED;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getPhase() == 1) {
            if (this.getSecondPhaseCounter() != 0 && this.getSecondPhaseCounter() <= 200) {
                event.getController().setAnimation(this.TRANSFORM);
            } else if (this.getMainAction() == 0) {
                RawAnimation vari = this.getSitVariation() == 0 ? this.LAY : (this.getSitVariation() == 1 ? this.SIT : this.SLEEP);
                event.getController().setAnimation(vari);
            } else if (this.getAttackType() == 1) {
                event.setAnimation(this.STAB);
            } else if (this.getAttackType() == 2) {
                event.setAnimation(this.AUTO_STAB);
            } else if (event.isMoving()) {
                event.getController().setAnimation(this.WALK);
            } else {
                event.getController().setAnimation(this.IDLE);
            }
        } else if (this.m_21224_()) {
            event.getController().setAnimation(this.MUTATED_DEATH);
        } else if (this.getMainAction() == 0) {
            RawAnimation vari = this.getIsOnAir() ? this.MUTATED_SIT3 : (this.getSitVariation() == 0 ? this.MUTATED_SIT1 : this.MUTATED_SIT2);
            event.getController().setAnimation(vari);
        } else if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.MUTATED_ATTACK1);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.MUTATED_ATTACK2);
        } else {
            event.getController().setAnimation(this.MUTATED_FLY);
        }
        return PlayState.CONTINUE;
    }
}

