/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.container.PuppetContainerMenu;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftBladeAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftCannonAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftMutantAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftWhipAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightBladeAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightCannonAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightMutantAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightWhipAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PuppetEntity
extends CompanionEntity
implements RangedAttackMob,
ContainerListener {
    public SimpleContainer inventory;
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK_L = RawAnimation.begin().thenPlay("attack_l");
    private final RawAnimation ATTACK_R = RawAnimation.begin().thenPlay("attack_r");
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> ATTACK_ANIMATION_NAME = SynchedEntityData.m_135353_(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING_RIGHT = SynchedEntityData.m_135353_(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING_LEFT = SynchedEntityData.m_135353_(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ACTIVE_ARMS = SynchedEntityData.m_135353_(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> ARM_NAMES = SynchedEntityData.m_135353_(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final ItemStack[] lastStacks = new ItemStack[]{ItemStack.f_41583_.m_41777_(), ItemStack.f_41583_.m_41777_()};
    private static final EntityDataAccessor<String> CURRENT_ATTACK_TYPE = SynchedEntityData.m_135353_(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public PuppetEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void createInventory() {
        SimpleContainer oldInv = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (oldInv != null) {
            int min = Math.min(oldInv.m_6643_(), this.inventory.m_6643_());
            for (int i = 0; i < min; ++i) {
                ItemStack stack = oldInv.m_8020_(i);
                this.inventory.m_6836_(i, stack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected int getInventorySize() {
        return 2;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new PuppetRightCannonAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(2, (Goal)new PuppetRightBladeAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(2, (Goal)new PuppetRightMutantAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(2, (Goal)new PuppetRightWhipAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(2, (Goal)new PuppetLeftCannonAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(2, (Goal)new PuppetLeftBladeAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(2, (Goal)new PuppetLeftMutantAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(2, (Goal)new PuppetLeftWhipAttackGoal(this, 10, 50));
        this.f_21345_.m_25352_(3, (Goal)new PuppetApproachTargetGoal(this, 0.5, 0.4f, 1.25f));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 6.0f, 2.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional h = this.m_20191_().m_82371_(player.m_146892_(), player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(5.0)));
            if (h.isPresent() && ((Vec3)h.get()).f_82480_ - this.m_20191_().f_82289_ < 2.0) {
                return false;
            }
        }
        boolean ret = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && amount > 4.0f && this.hasArm(CompanionsItems.MUTANT_ARM.get()) && this.m_5448_() != null) {
            this.spawnMutantParticles(15);
            this.tpOppositeSide();
            this.spawnMutantParticles(15);
        }
        return ret;
    }

    private void spawnMutantParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, dx, dy, dz, 0.1);
            if (i % 5 != 0) continue;
            level2.m_8767_((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, dx, dy, dz, 0.2);
        }
    }

    private void tpOppositeSide() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        Vec3 pos = target.m_20182_();
        Vec3 newPos = pos.m_82492_(this.m_20182_().f_82479_ - pos.f_82479_, 0.0, this.m_20182_().f_82481_ - pos.f_82481_);
        if (this.isValidTeleportPos(newPos)) {
            this.m_6034_(newPos.f_82479_, this.m_20182_().f_82480_, newPos.f_82481_);
        }
    }

    private boolean isValidTeleportPos(Vec3 newPos) {
        BlockPos feet = new BlockPos((int)newPos.f_82479_, (int)newPos.f_82480_, (int)newPos.f_82481_);
        BlockPos head = new BlockPos((int)newPos.f_82479_, (int)newPos.f_82480_ + 1, (int)newPos.f_82481_);
        BlockPos floor = new BlockPos((int)newPos.f_82479_, (int)newPos.f_82480_ - 1, (int)newPos.f_82481_);
        boolean f1 = this.m_9236_().m_8055_(feet).m_60795_() && this.m_9236_().m_8055_(head).m_60795_();
        boolean f2 = this.m_9236_().m_8055_(floor).m_60804_((BlockGetter)this.m_9236_(), floor);
        return f1 && f2;
    }

    public boolean hasArm(Item armItem) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != armItem) continue;
            return true;
        }
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.PUPPET_MAX_LIFE).m_22268_(Attributes.f_22281_, CompanionsConfig.PUPPET_DAMAGE).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    public void setActiveArms(int candleCount) {
        this.f_19804_.m_135381_(ACTIVE_ARMS, (Object)candleCount);
    }

    public int getActiveArms() {
        return (Integer)this.f_19804_.m_135370_(ACTIVE_ARMS);
    }

    public boolean isAttackingRight() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING_RIGHT);
    }

    public void setAttackingRight(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING_RIGHT, (Object)attacking);
    }

    public boolean isAttackingLeft() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING_LEFT);
    }

    public void setAttackingLeft(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING_LEFT, (Object)attacking);
    }

    public void setArmNames(String armNames) {
        this.f_19804_.m_135381_(ARM_NAMES, (Object)armNames);
    }

    public String getArmNames() {
        return (String)this.f_19804_.m_135370_(ARM_NAMES);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING_RIGHT, (Object)false);
        this.f_19804_.m_135372_(IS_ATTACKING_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(ATTACK_ANIMATION_NAME, (Object)"");
        this.f_19804_.m_135372_(ACTIVE_ARMS, (Object)0);
        this.f_19804_.m_135372_(CURRENT_ATTACK_TYPE, (Object)"NONE");
        this.f_19804_.m_135372_(ARM_NAMES, (Object)"none,none");
    }

    @Nullable
    public LivingEntity m_269323_() {
        return super.m_269323_();
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (this.m_21824_() && this.m_269323_() == player && player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (!this.m_9236_().f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return PuppetEntity.this.m_7755_();
                    }

                    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInv, @NotNull Player player) {
                        return new PuppetContainerMenu(id, playerInv, PuppetEntity.this);
                    }
                }, buf -> buf.writeInt(this.m_19879_()));
                this.m_5496_(SoundEvents.f_11678_, 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.inventory.m_7797_(pCompound.m_128437_("Inventory", 10));
        this.updateContainerEquipment();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return true;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.PUPPET_KEEP_CHUNK_LOADED;
    }

    public void m_6504_(@NotNull LivingEntity target, float v) {
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.PUPPET_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(CompanionsSounds.PUPPET_WALK.get(), 0.45f, 1.0f);
    }

    public void m_5757_(@NotNull Container container) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack old = this.lastStacks[i];
            ItemStack now = this.inventory.m_8020_(i);
            if (ItemStack.m_41728_((ItemStack)old, (ItemStack)now)) continue;
            this.lastStacks[i] = now.m_41777_();
            if (now.m_41619_()) continue;
            Item item = now.m_41720_();
            if (item == CompanionsItems.CANNON_ARM.get()) {
                this.m_5496_(CompanionsSounds.PUPPET_EQUIP_CANON.get(), 0.75f, 1.0f);
                continue;
            }
            if (item == CompanionsItems.MUTANT_ARM.get()) {
                this.m_5496_(CompanionsSounds.PUPPET_EQUIP_MUTANT.get(), 0.75f, 1.0f);
                continue;
            }
            if (item == CompanionsItems.WHIP_ARM.get()) {
                this.m_5496_(CompanionsSounds.PUPPET_EQUIP_WHIP.get(), 0.75f, 1.0f);
                continue;
            }
            if (item != CompanionsItems.BLADE_ARM.get()) continue;
            this.m_5496_(CompanionsSounds.PUPPET_EQUIP_BLADE.get(), 0.75f, 1.0f);
        }
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            Item item;
            this.setFlag(!this.inventory.m_8020_(0).m_41619_());
            int arms = 0;
            String leftArm = "none";
            String rightArm = "none";
            if (!this.inventory.m_8020_(0).m_41619_()) {
                arms |= 2;
                item = this.inventory.m_8020_(0).m_41720_();
                if (item == CompanionsItems.CANNON_ARM.get()) {
                    rightArm = "cannon";
                } else if (item == CompanionsItems.MUTANT_ARM.get()) {
                    rightArm = "mutant";
                } else if (item == CompanionsItems.WHIP_ARM.get()) {
                    rightArm = "whip";
                } else if (item == CompanionsItems.BLADE_ARM.get()) {
                    rightArm = "blade";
                }
            }
            if (!this.inventory.m_8020_(1).m_41619_()) {
                arms |= 1;
                item = this.inventory.m_8020_(1).m_41720_();
                if (item == CompanionsItems.CANNON_ARM.get()) {
                    leftArm = "cannon";
                } else if (item == CompanionsItems.MUTANT_ARM.get()) {
                    leftArm = "mutant";
                } else if (item == CompanionsItems.WHIP_ARM.get()) {
                    leftArm = "whip";
                } else if (item == CompanionsItems.BLADE_ARM.get()) {
                    leftArm = "blade";
                }
            }
            this.setActiveArms(arms);
            this.setArmNames(leftArm + "," + rightArm);
        }
    }

    protected void setFlag(boolean b) {
        byte $$2 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (b) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)($$2 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)($$2 & 0xFFFFFFFB)));
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemStack)) continue;
                this.m_19983_(itemStack);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rightAttackcontroller", 1, this::rightAttackPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "leftAttackcontroller", 1, this::leftAttackPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState rightAttackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isAttackingRight()) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.ATTACK_R);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState leftAttackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isAttackingLeft()) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.ATTACK_L);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

