/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.container.CorneliusContainerMenu;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusAttackBeeGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusBubbleFrogGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusEmberPoleGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusEnderFrogGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusFireworkToadGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusMoveToBeeGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusNetherBullfrogGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.HopToOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomHopStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class CorneliusEntity
extends CompanionEntity
implements ContainerListener,
IFrogJumpUtil {
    public SimpleContainer inventory;
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation SIT2 = RawAnimation.begin().thenPlay("sit2");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation SUMMON = RawAnimation.begin().thenPlay("summon");
    private final RawAnimation SUMMON2 = RawAnimation.begin().thenPlay("summon2");
    private final RawAnimation SUMMON3 = RawAnimation.begin().thenPlay("summon3");
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_ATTACK = SynchedEntityData.m_135353_(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SUMMONED_COUNT = SynchedEntityData.m_135353_(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CYCLE_COUNTER = SynchedEntityData.m_135353_(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_CYCLE_TICKS = 20;

    public CorneliusEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void createInventory() {
        SimpleContainer oldInv = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (oldInv != null) {
            int min = Math.min(oldInv.m_6643_(), this.inventory.m_6643_());
            for (int i = 0; i < min; ++i) {
                ItemStack stack = oldInv.m_8020_(i);
                this.inventory.m_6836_(i, stack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
    }

    public int getCycleCount() {
        return (Integer)this.f_19804_.m_135370_(CYCLE_COUNTER);
    }

    public void setCycleCount(int count) {
        this.f_19804_.m_135381_(CYCLE_COUNTER, (Object)count);
    }

    @Override
    public boolean m_21532_() {
        return true;
    }

    protected int getInventorySize() {
        return 6;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new CorneliusFireworkToadGoal(this, 60, 260));
        this.f_21345_.m_25352_(2, (Goal)new CorneliusNetherBullfrogGoal(this, 60, 260));
        this.f_21345_.m_25352_(2, (Goal)new CorneliusBubbleFrogGoal(this, 60, 260));
        this.f_21345_.m_25352_(2, (Goal)new CorneliusEnderFrogGoal(this, 60, 260));
        this.f_21345_.m_25352_(2, (Goal)new CorneliusEmberPoleGoal(this, 60, 260));
        this.f_21345_.m_25352_(3, (Goal)new CorneliusMoveToBeeGoal(this, 0.725));
        this.f_21345_.m_25352_(3, (Goal)new CorneliusAttackBeeGoal(this, 10, 30));
        this.f_21345_.m_25352_(4, new HopToOwnerGoal<CorneliusEntity>(this, 0.725, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new CompanionRandomHopStrollGoal(this, 0.725));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    public boolean canAttack() {
        return (Boolean)this.f_19804_.m_135370_(CAN_ATTACK);
    }

    @Override
    public void setCanAttack(boolean canAttack) {
        this.f_19804_.m_135381_(CAN_ATTACK, (Object)canAttack);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getCycleCount() == 0) {
                this.m_5496_(CompanionsSounds.FROGGY_JUMP.get(), 0.5f, 1.0f);
            }
            if (this.getCycleCount() >= 12) {
                this.m_20256_(new Vec3(0.0, 0.0, 0.0));
            }
            if (this.getCycleCount() >= 0) {
                this.setCycleCount(this.getCycleCount() + 1);
            }
            if (this.getCycleCount() >= 20) {
                this.setCycleCount(-1);
            }
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return CompanionsSounds.FROGGY_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.FROGGY_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return CompanionsSounds.FROGGY_DEATH.get();
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.CORNELIUS_MAX_LIFE).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(CAN_ATTACK, (Object)true);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(SUMMONED_COUNT, (Object)0);
        this.f_19804_.m_135372_(CYCLE_COUNTER, (Object)-1);
    }

    @Override
    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)type);
    }

    public int getSummonedCount() {
        return (Integer)this.f_19804_.m_135370_(SUMMONED_COUNT);
    }

    public void setSummonedCount(int c) {
        this.f_19804_.m_135381_(SUMMONED_COUNT, (Object)c);
    }

    @Nullable
    public LivingEntity m_269323_() {
        return super.m_269323_();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_21824_() && this.m_269323_() == player && player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (!this.m_9236_().f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return CorneliusEntity.this.m_7755_();
                    }

                    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInv, @NotNull Player player) {
                        return new CorneliusContainerMenu(id, playerInv, CorneliusEntity.this);
                    }
                }, buf -> buf.writeInt(this.m_19879_()));
                this.m_5496_(SoundEvents.f_11678_, 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.inventory.m_7797_(pCompound.m_128437_("Inventory", 10));
        if (pCompound.m_128441_("SummonedCount")) {
            this.setSummonedCount(pCompound.m_128451_("SummonedCount"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        pCompound.m_128405_("SummonedCount", this.getSummonedCount());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.CORNELIUS_KEEP_CHUNK_LOADED;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemStack)) continue;
                this.m_19983_(itemStack);
            }
        }
    }

    public static boolean checkCorneliusSpawnRules(EntityType<CorneliusEntity> cornelius, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pRandom.m_188503_(20) == 0 && CorneliusEntity.m_217057_(cornelius, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom) && CorneliusEntity.m_218104_(cornelius, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public void m_5757_(@NotNull Container container) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.setAnimation(this.getSitVariation() == 0 ? this.SIT : this.SIT2);
        } else if (this.getAttackType() == 1) {
            event.setAnimation(this.SUMMON);
        } else if (this.getAttackType() == 2) {
            event.setAnimation(this.SUMMON2);
        } else if (this.getAttackType() == 3) {
            event.setAnimation(this.SUMMON3);
        } else if (this.getCycleCount() >= 0) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

