/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.shade;

import dev.xylonity.companions.common.entity.ShadeEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractShadeAttackGoal
extends Goal {
    protected final ShadeEntity shade;
    protected final int attackDuration;
    private final int minCooldown;
    private final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractShadeAttackGoal(ShadeEntity shade, int attackDuration, int minCd, int maxCd) {
        this.shade = shade;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.shade.isSpawning()) {
            return false;
        }
        if (((Object)((Object)this.shade)).getClass() != this.shadeType()) {
            return false;
        }
        if (this.shade.getAttackType() != 0) {
            return false;
        }
        if (this.shade.m_5448_() == null) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.shade.f_19797_ + this.minCooldown + this.shade.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.shade.f_19797_ >= this.nextUseTick;
    }

    public boolean m_8045_() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void m_8056_() {
        this.attackTicks = 0;
        this.started = true;
        this.shade.setAttackType(this.getAttackType());
    }

    public void m_8041_() {
        this.started = false;
        this.shade.setAttackType(0);
        int cd = this.minCooldown + this.shade.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.shade.f_19797_ + cd;
    }

    public void m_8037_() {
        LivingEntity target = this.shade.m_5448_();
        if (target != null) {
            this.shade.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.m_6084_()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget = target.m_20191_().m_82399_().m_82546_(viewer.m_20299_(1.0f));
        double distance = toTarget.m_82553_();
        if (distance < 1.0E-6) {
            return true;
        }
        Vec3 norm = toTarget.m_82490_(1.0 / distance);
        return viewer.m_20154_().m_82526_(norm) >= Math.cos(Math.toRadians(fov / 2.0));
    }

    public boolean m_183429_() {
        return true;
    }

    protected abstract int getAttackType();

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract Class<? extends ShadeEntity> shadeType();
}

