/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.summon.FireworkToadEntity;
import dev.xylonity.companions.common.util.Util;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkToadGoal
extends AbstractCorneliusSummonAttackGoal {
    private Vec3 p0;
    private Vec3 p1;
    private Vec3 p2;
    private int totalTicks;
    private boolean flying;

    public FireworkToadGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 110, minCd, maxCd);
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        FireworkToadEntity toad = (FireworkToadEntity)this.summon;
        LivingEntity target = toad.m_5448_();
        if (target == null || !target.m_6084_()) {
            return;
        }
        this.p0 = toad.m_20182_();
        this.p2 = target.m_20182_();
        double horiz = new Vec3(this.p2.f_82479_ - this.p0.f_82479_, 0.0, this.p2.f_82481_ - this.p0.f_82481_).m_82553_();
        double y = Math.max(this.p0.f_82480_, this.p2.f_82480_) + Mth.m_14008_((double)(horiz * 1.15), (double)1.0, (double)12.0);
        this.p1 = new Vec3((this.p0.f_82479_ + this.p2.f_82479_) * 0.5, y, (this.p0.f_82481_ + this.p2.f_82481_) * 0.5);
        this.totalTicks = new Random().nextInt(70, 110);
        this.flying = true;
        toad.setFlying(true);
        toad.setNoMovement(true);
        toad.m_20242_(true);
        toad.f_19794_ = true;
        toad.m_21573_().m_26573_();
        toad.m_20256_(Vec3.f_82478_);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (!this.flying) {
            return;
        }
        Vec3 pos = Util.bezier(this.p0, this.p1, this.p2, (double)this.attackTicks / (double)this.totalTicks);
        this.summon.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.summon.m_20256_(Vec3.f_82478_);
        Vec3 dir = Util.bezier(this.p0, this.p1, this.p2, Math.min((double)this.attackTicks / (double)this.totalTicks + 0.01, 1.0)).m_82546_(pos).m_82541_();
        float yaw = (float)(Mth.m_14136_((double)dir.f_82481_, (double)dir.f_82479_) * 180.0 / Math.PI) - 90.0f;
        this.summon.m_146922_(yaw);
        this.summon.m_5618_(yaw);
        this.summon.m_146926_((float)(-Mth.m_14136_((double)dir.f_82480_, (double)Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 180.0 / Math.PI));
        ++this.attackTicks;
        if (this.attackTicks >= this.totalTicks) {
            this.spawnRockets(pos);
            FireworkToadGoal.resetPhysics((FireworkToadEntity)this.summon);
            this.summon.m_142687_(Entity.RemovalReason.DISCARDED);
            this.flying = false;
        }
        if (this.attackTicks == this.totalTicks / 2) {
            this.summon.triggerAnim("rot_controller", "rot");
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        if (this.flying && this.summon.m_6084_()) {
            FireworkToadGoal.resetPhysics((FireworkToadEntity)this.summon);
        }
        this.flying = false;
    }

    @Override
    protected void performAttack(LivingEntity owner) {
    }

    private static void resetPhysics(FireworkToadEntity toad) {
        toad.setFlying(false);
        toad.setNoMovement(false);
        toad.m_20242_(false);
        toad.f_19794_ = false;
        toad.m_20256_(Vec3.f_82478_);
        toad.setParabolaCenter(null);
    }

    private void spawnRockets(Vec3 center) {
        Level level = this.summon.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123747_, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            for (int i = 0; i < 6; ++i) {
                double angle = this.summon.m_217043_().m_188500_() * Math.PI * 2.0;
                double dist = this.summon.m_217043_().m_188500_() * 8.0;
                double dx = Math.cos(angle) * dist;
                double dz = Math.sin(angle) * dist;
                double dy = 3.0 + this.summon.m_217043_().m_188500_() * 7.0;
                FireworkToadGoal.rocket(level2, new Vec3(center.f_82479_ + dx, center.f_82480_ + dy, center.f_82481_ + dz), this.summon.m_217043_());
            }
            FireworkToadGoal.rocket(level2, new Vec3(center.f_82479_, center.f_82480_ + 0.5, center.f_82481_), this.summon.m_217043_());
            for (LivingEntity e : level2.m_45976_(LivingEntity.class, this.summon.m_20191_().m_82400_(3.0))) {
                if (Util.areEntitiesLinked((Entity)e, (Entity)this.summon)) continue;
                this.summon.m_7327_((Entity)e);
            }
        }
    }

    private static void rocket(ServerLevel world, Vec3 where, RandomSource r) {
        CompoundTag fwTag = new CompoundTag();
        fwTag.m_128344_("Flight", (byte)1);
        double rand = r.m_188500_();
        int shape = rand < 0.3 ? (r.m_188499_() ? 0 : 1) : (rand < 0.6 ? 2 : 4);
        CompoundTag exp = new CompoundTag();
        exp.m_128344_("Type", (byte)shape);
        exp.m_128379_("Trail", false);
        exp.m_128379_("Flicker", true);
        int cr = 128 + r.m_188503_(128);
        int cg = 128 + r.m_188503_(128);
        int cb = 128 + r.m_188503_(128);
        int color = cr << 16 | cg << 8 | cb;
        exp.m_128385_("Colors", new int[]{color});
        exp.m_128385_("FadeColors", new int[]{color});
        ListTag expls = new ListTag();
        expls.add((Object)exp);
        fwTag.m_128365_("Explosions", (Tag)expls);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42688_);
        stack.m_41700_("Fireworks", (Tag)fwTag);
        FireworkRocketEntity rocket = new FireworkRocketEntity((Level)world, where.f_82479_, where.f_82480_, where.f_82481_, stack);
        world.m_7967_((Entity)rocket);
        world.m_7605_((Entity)rocket, (byte)17);
        rocket.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected int getAttackType() {
        return 1;
    }

    @Override
    protected int attackDelay() {
        return -1;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return FireworkToadEntity.class;
    }
}

