/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius;

import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public abstract class AbstractCorneliusAttackGoal
extends Goal {
    protected final CorneliusEntity cornelius;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;
    protected int currentAttackDelay;
    protected int currentAttackDuration;
    protected static final int SPAWN_RADIUS = 3;
    protected static final int MAX_SPAWN_ATTEMPTS = 20;

    public AbstractCorneliusAttackGoal(CorneliusEntity cornelius, int minCd, int maxCd) {
        this.cornelius = cornelius;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.cornelius.m_21824_()) {
            return false;
        }
        if (!this.cornelius.canAttack()) {
            return false;
        }
        if (this.cornelius.getAttackType() != 0) {
            return false;
        }
        if (this.cornelius.m_5448_() == null) {
            return false;
        }
        if (!this.hasSufficientCoins()) {
            this.nextUseTick = -1;
            return false;
        }
        if (this.nextUseTick < 0) {
            int cd = this.minCooldown + this.cornelius.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
            this.nextUseTick = this.cornelius.f_19797_ + cd;
            return false;
        }
        return this.cornelius.f_19797_ >= this.nextUseTick;
    }

    public boolean m_8045_() {
        return this.started && this.attackTicks < this.currentAttackDuration;
    }

    public void m_8056_() {
        int currentAttackType = this.cornelius.m_217043_().m_188503_(3) + 1;
        switch (currentAttackType) {
            case 1: {
                this.currentAttackDelay = 15;
                this.currentAttackDuration = 30;
                break;
            }
            case 2: {
                this.currentAttackDelay = 17;
                this.currentAttackDuration = 25;
                break;
            }
            default: {
                this.currentAttackDelay = 18;
                this.currentAttackDuration = 26;
            }
        }
        this.attackTicks = 0;
        this.started = true;
        this.cornelius.setAttackType(currentAttackType);
        this.cornelius.setSummonedCount(this.cornelius.getSummonedCount() + 1);
        this.consumeCoins();
        this.cornelius.m_216990_(CompanionsSounds.FROGGY_ATTACK.get());
    }

    public void m_8041_() {
        this.started = false;
        this.cornelius.setAttackType(0);
        this.nextUseTick = -1;
    }

    public void m_8037_() {
        LivingEntity target = this.cornelius.m_5448_();
        if (target != null) {
            this.cornelius.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.currentAttackDelay && target != null && target.m_6084_()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean m_183429_() {
        return true;
    }

    protected boolean hasSufficientCoins() {
        int found = 0;
        for (int i = 0; i <= 2; ++i) {
            ItemStack stack = this.cornelius.inventory.m_8020_(i);
            if (stack.m_41720_() != this.coin() || (found += stack.m_41613_()) < this.coinsToConsume()) continue;
            return true;
        }
        return false;
    }

    protected void consumeCoins() {
        int toConsume = this.coinsToConsume();
        for (int i = 0; i <= 2 && toConsume > 0; ++i) {
            ItemStack stack = this.cornelius.inventory.m_8020_(i);
            if (stack.m_41720_() != this.coin()) continue;
            int remove = Math.min(toConsume, stack.m_41613_());
            stack.m_41774_(remove);
            toConsume -= remove;
            this.cornelius.inventory.m_6836_(i, stack);
        }
    }

    protected boolean isValidSpawnPosition(Level level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        return !level.m_8055_(pos).m_60804_((BlockGetter)level, pos) && !level.m_8055_(abovePos).m_60804_((BlockGetter)level, abovePos) && level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos.m_7495_());
    }

    protected BlockPos findPosAroundCornelius() {
        for (int attempt = 0; attempt < 20; ++attempt) {
            int x = this.cornelius.m_20183_().m_123341_() + this.cornelius.m_217043_().m_188503_(7) - 3;
            int z = this.cornelius.m_20183_().m_123343_() + this.cornelius.m_217043_().m_188503_(7) - 3;
            BlockPos surf = this.findSurfacePosition(this.cornelius.m_9236_(), new BlockPos(x, this.cornelius.m_20183_().m_123342_(), z));
            if (surf == null || !this.isValidSpawnPosition(this.cornelius.m_9236_(), surf)) continue;
            return surf;
        }
        return this.cornelius.m_20183_();
    }

    protected BlockPos findPosAroundTarget() {
        if (this.cornelius.m_5448_() != null) {
            for (int attempt = 0; attempt < 40; ++attempt) {
                int x = this.cornelius.m_5448_().m_20183_().m_123341_() + this.cornelius.m_5448_().m_217043_().m_188503_(15) - 7;
                int z = this.cornelius.m_5448_().m_20183_().m_123343_() + this.cornelius.m_5448_().m_217043_().m_188503_(15) - 7;
                BlockPos surf = this.findSurfacePosition(this.cornelius.m_5448_().m_9236_(), new BlockPos(x, this.cornelius.m_5448_().m_20183_().m_123342_(), z));
                if (surf == null || !this.isValidSpawnPosition(this.cornelius.m_5448_().m_9236_(), surf)) continue;
                return surf;
            }
            return this.cornelius.m_5448_().m_20183_();
        }
        return this.cornelius.m_20183_();
    }

    private BlockPos findSurfacePosition(Level level, BlockPos startPos) {
        BlockPos abovePos;
        BlockPos checkPos;
        int y;
        for (y = startPos.m_123342_(); y > level.m_141937_(); --y) {
            checkPos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
            abovePos = checkPos.m_7494_();
            if (!level.m_8055_(checkPos).m_60804_((BlockGetter)level, checkPos) || level.m_8055_(abovePos).m_60804_((BlockGetter)level, abovePos)) continue;
            return abovePos;
        }
        for (y = startPos.m_123342_(); y < level.m_151558_(); ++y) {
            checkPos = new BlockPos(startPos.m_123341_(), y, startPos.m_123343_());
            abovePos = checkPos.m_7494_();
            if (!level.m_8055_(checkPos).m_60804_((BlockGetter)level, checkPos) || level.m_8055_(abovePos).m_60804_((BlockGetter)level, abovePos)) continue;
            return abovePos;
        }
        return null;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract Item coin();

    protected abstract int coinsToConsume();
}

