/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.item.ShadowBellItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ShadeSwordAltarBlockEntity
extends AbstractShadeAltarBlockEntity {
    private int tickCount = 0;
    private boolean shouldSpawnParticleExplosion = false;

    public ShadeSwordAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CompanionsBlockEntities.SHADE_SWORD_ALTAR.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T F) {
        if (F instanceof ShadeSwordAltarBlockEntity) {
            ServerLevel sv;
            double dz;
            double dy;
            double dx;
            ShadeSwordAltarBlockEntity altar = (ShadeSwordAltarBlockEntity)F;
            if (altar.tickCount % 20 == 0 && altar.getCharges() >= altar.getMaxCharges() - altar.getBloodCharges()) {
                double dx2 = (new Random().nextDouble() - 0.5) * 0.5;
                double dy2 = (new Random().nextDouble() - 0.5) * 0.5;
                double dz2 = (new Random().nextDouble() - 0.5) * 0.5;
                if (level instanceof ServerLevel) {
                    ServerLevel sv2 = (ServerLevel)level;
                    sv2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), (double)altar.m_58899_().m_123341_() + 0.5, (double)altar.m_58899_().m_123342_() + 0.25 * Math.random(), (double)altar.m_58899_().m_123343_() + 0.5, 1, dx2, dy2, dz2, 0.1);
                }
            }
            if (altar.shouldSpawnParticleExplosion && altar.getCharges() == 1) {
                for (int i = 0; i < 10; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.5;
                    dy = (new Random().nextDouble() - 0.5) * 0.5;
                    dz = (new Random().nextDouble() - 0.5) * 0.5;
                    if (!(level instanceof ServerLevel)) continue;
                    sv = (ServerLevel)level;
                    sv.m_8767_((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), (double)altar.m_58899_().m_123341_() + 0.5, (double)altar.m_58899_().m_123342_() + 0.25 * Math.random(), (double)altar.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.15);
                    if (i % 3 != 0) continue;
                    sv.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), (double)altar.m_58899_().m_123341_() + 0.5, (double)altar.m_58899_().m_123342_() + 0.25 * Math.random(), (double)altar.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.35);
                }
                altar.shouldSpawnParticleExplosion = false;
            }
            if (altar.shouldSpawnParticleExplosion && altar.getCharges() == altar.getMaxCharges() - altar.getBloodCharges()) {
                for (int i = 0; i < 20; ++i) {
                    dx = (new Random().nextDouble() - 0.5) * 0.6;
                    dy = (new Random().nextDouble() - 0.5) * 0.6;
                    dz = (new Random().nextDouble() - 0.5) * 0.6;
                    if (!(level instanceof ServerLevel)) continue;
                    sv = (ServerLevel)level;
                    sv.m_8767_((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), (double)altar.m_58899_().m_123341_() + 0.5, (double)altar.m_58899_().m_123342_() + 0.35 * Math.random(), (double)altar.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.15);
                    if (i % 3 != 0) continue;
                    sv.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), (double)altar.m_58899_().m_123341_() + 0.5, (double)altar.m_58899_().m_123342_() + 0.35 * Math.random(), (double)altar.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.35);
                }
                altar.shouldSpawnParticleExplosion = false;
            }
            if (altar.getCharges() > 0 && altar.tickCount % 2 == 0 && (double)level.f_46441_.m_188501_() < 0.01 * (double)altar.getCharges() && altar.f_58857_ != null && altar.f_58857_.f_46443_) {
                Companions.PROXY.spawnShadeAltarParticles(altar, level, 0.0f, 0.0f, 0.0f, 5.0);
            }
            ++altar.tickCount;
        }
    }

    @Override
    protected boolean hasIncreasedFromPrevInteraction() {
        boolean ret = super.hasIncreasedFromPrevInteraction();
        if (ret) {
            this.shouldSpawnParticleExplosion = true;
        }
        return ret;
    }

    @Override
    public ShadeEntity spawnShade(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand, ShadowBellItem shadowBell) {
        ShadeEntity entity = (ShadeEntity)((EntityType)CompanionsEntities.SHADE_SWORD.get()).m_20615_(pLevel);
        if (entity != null) {
            entity.m_21828_(pPlayer);
            double r1 = 2.0;
            double r2 = 3.0;
            double u = pLevel.f_46441_.m_188500_();
            double r = Math.sqrt(u * (r2 * r2 - r1 * r1) + r1 * r1);
            float randYaw = pPlayer.m_146908_() + (pLevel.f_46441_.m_188501_() * 2.0f - 1.0f) * 30.0f;
            float randPitch = pPlayer.m_146909_() + (pLevel.f_46441_.m_188501_() * 2.0f - 1.0f) * 20.0f;
            Vec3 target = pPlayer.m_20299_(1.0f).m_82549_(Vec3.m_82498_((float)randPitch, (float)randYaw).m_82490_(r));
            int blockX = Mth.m_14107_((double)target.f_82479_);
            int blockZ = Mth.m_14107_((double)target.f_82481_);
            double px = (double)blockX + 0.5;
            double py = this.findPlaceToSpawn(pPlayer, pLevel, blockX, blockZ);
            double pz = (double)blockZ + 0.5;
            entity.m_6027_(px, py, pz);
            for (int i = 0; i < 20; ++i) {
                double vx = (pLevel.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
                double vy = (pLevel.f_46441_.m_188500_() - 0.5) * (double)entity.m_20206_();
                double vz = (pLevel.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
                if (!(pLevel instanceof ServerLevel)) continue;
                ServerLevel svlvl = (ServerLevel)pLevel;
                svlvl.m_8767_((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), px, py, pz, 1, vx, vy, vz, 0.15);
                if (i % 3 != 0) continue;
                svlvl.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), px, py, pz, 1, vx, vy, vz, 0.35);
            }
            if (this.isBloodUpgradeActive()) {
                AttributeInstance dmg;
                entity.setIsBlood(true);
                AttributeInstance maxHealth = entity.m_21051_(Attributes.f_22276_);
                if (maxHealth != null) {
                    float updatedHealth = (float)(maxHealth.m_22115_() * CompanionsConfig.SHADOW_SWORD_BLOOD_MULTIPLIER);
                    maxHealth.m_22100_((double)updatedHealth);
                    entity.m_21153_(updatedHealth);
                }
                if ((dmg = entity.m_21051_(Attributes.f_22281_)) != null) {
                    dmg.m_22100_(dmg.m_22115_() * CompanionsConfig.SHADOW_SWORD_BLOOD_MULTIPLIER);
                }
            }
            if (pPlayer.m_21120_(pUsedHand).m_41788_()) {
                entity.setHasReskin(true);
            }
            double dx = pPlayer.m_20185_() - px;
            double dy = pPlayer.m_20186_() + (double)pPlayer.m_20192_() - (py + (double)entity.m_20192_());
            double dz = pPlayer.m_20189_() - pz;
            float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232));
            entity.m_146922_(yaw);
            entity.f_20883_ = yaw;
            entity.f_20884_ = yaw;
            entity.f_20885_ = yaw;
            entity.f_20886_ = yaw;
            entity.m_146926_(pitch);
            entity.f_19860_ = pitch;
            entity.m_6842_(true);
            pLevel.m_7967_((Entity)entity);
            this.activeShadeUUID = entity.m_20148_();
            return entity;
        }
        return null;
    }
}

