/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.client.entity.model.IllagerGolemModel;
import dev.xylonity.companions.common.entity.hostile.IllagerGolemEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class IllagerGolemRenderer
extends GeoEntityRenderer<IllagerGolemEntity> {
    public IllagerGolemRenderer(EntityRendererProvider.Context renderManager, int totalFrames, int ticksPerFrame) {
        super(renderManager, (GeoModel)new IllagerGolemModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer(new ElectricConnectionLayer((GeoRenderer<IllagerGolemEntity>)this, new ResourceLocation("companions", "textures/misc/illager_golem_electric_arch.png"), totalFrames, ticksPerFrame));
        this.f_114477_ = 1.0f;
    }

    public IllagerGolemRenderer(EntityRendererProvider.Context renderManager) {
        this(renderManager, 8, 1);
    }

    private static class ElectricConnectionLayer
    extends GeoRenderLayer<IllagerGolemEntity> {
        private final ResourceLocation texture;
        private final int totalFrames;
        private final int ticksPerFrame;

        public ElectricConnectionLayer(GeoRenderer<IllagerGolemEntity> renderer, ResourceLocation texture, int totalFrames, int ticksPerFrame) {
            super(renderer);
            this.texture = texture;
            this.totalFrames = totalFrames;
            this.ticksPerFrame = ticksPerFrame;
        }

        public void render(PoseStack poseStack, IllagerGolemEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (!animatable.isActive()) {
                return;
            }
            int frame = this.calculateCurrentFrame(animatable);
            if (frame < 0) {
                return;
            }
            for (Entity e : animatable.visibleEntities) {
                Vec3 offset = new Vec3(0.0, (double)animatable.m_20206_() * 0.95, 0.0);
                Vec3 direction = e.m_20182_().m_82546_(animatable.m_20182_()).m_82520_(0.0, (double)e.m_20206_() * 0.5, 0.0);
                this.renderConnection(bufferSource, poseStack, offset, direction, frame, packedLight);
            }
        }

        private int calculateCurrentFrame(IllagerGolemEntity animatable) {
            int elapsedTicks = animatable.getTickCount() - animatable.getAnimationStartTick();
            int frame = elapsedTicks / this.ticksPerFrame;
            if (frame >= this.totalFrames) {
                return -1;
            }
            return frame;
        }

        private void renderConnection(MultiBufferSource bufferSource, PoseStack poseStack, Vec3 p0, Vec3 p1, int frame, int light) {
            int[] indices;
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.texture));
            Matrix4f positionMatrix = poseStack.m_85850_().m_252922_();
            Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
            float x0 = (float)p0.f_82479_;
            float y0 = (float)p0.f_82480_;
            float z0 = (float)p0.f_82481_;
            float x1 = (float)p1.f_82479_;
            float y1 = (float)p1.f_82480_;
            float z1 = (float)p1.f_82481_;
            float dx = x1 - x0;
            float dy = y1 - y0;
            float dz = z1 - z0;
            if (dx == 0.0f) {
                dx = 0.001f;
            }
            float dHorizontal = Mth.m_14116_((float)(dx * dx + dz * dz));
            float length = Mth.m_14116_((float)(dHorizontal * dHorizontal + dy * dy));
            float offset = 0.5f;
            float yOffset = offset * (dHorizontal / length);
            float xOffset = offset * (dy / length) * (dx / dHorizontal);
            float zOffset = offset * (dy / length) * (dz / dHorizontal);
            float frameSize = 1.0f / (float)this.totalFrames;
            float v0 = (float)frame * frameSize;
            float v1 = v0 + frameSize;
            VertexCoordinates[] vertices = new VertexCoordinates[]{new VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
            for (int i : indices = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
                this.produceVertex(vertexConsumer, positionMatrix, normalMatrix, light, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v);
            }
        }

        private void produceVertex(VertexConsumer vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, int light, float x, float y, float z, float textureU, float textureV) {
            vertexConsumer.m_252986_(positionMatrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(textureU, textureV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        }

        private record VertexCoordinates(float x, float y, float z, float u, float v) {
        }
    }
}

