/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc.shadow.kaleido.lib.quiltconfig.api.values;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.Constraint;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.metadata.MetadataContainerBuilder;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.metadata.MetadataType;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.values.ValueKey;
import link.e4mc.shadow.kaleido.lib.quiltconfig.api.values.ValueTreeNode;
import link.e4mc.shadow.kaleido.lib.quiltconfig.impl.builders.TrackedValueBuilderImpl;
import link.e4mc.shadow.kaleido.lib.quiltconfig.impl.tree.TrackedValueImpl;
import link.e4mc.shadow.kaleido.lib.quiltconfig.impl.util.ConfigUtils;
import link.e4mc.shadow.kaleido.lib.quiltconfig.impl.values.ValueKeyImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface TrackedValue<T>
extends ValueTreeNode {
    @Override
    public ValueKey key();

    public T value();

    public boolean isBeingOverridden();

    public T getRealValue();

    public T setValue(@NotNull T var1, boolean var2);

    default public T setValue(@NotNull T newValue) {
        return this.setValue(newValue, true);
    }

    public void setOverride(T var1);

    public void removeOverride();

    public T getDefaultValue();

    public void registerCallback(UpdateCallback<T> var1);

    @Override
    public <M> M metadata(MetadataType<M, ?> var1);

    @Override
    public <M> boolean hasMetadata(MetadataType<M, ?> var1);

    public Iterable<Constraint<T>> constraints();

    public Optional<Iterable<String>> checkForFailingConstraints(T var1);

    public static <T> TrackedValue<T> create(@NotNull T defaultValue, @NotNull String key0, String ... keys) {
        ConfigUtils.assertValueType(defaultValue);
        Objects.requireNonNull(key0);
        return new TrackedValueImpl<T>(new ValueKeyImpl(key0, keys), defaultValue, new LinkedHashMap(0), new ArrayList(0), new ArrayList(0));
    }

    public static <T> TrackedValue<T> create(@NotNull T defaultValue, String key0, Consumer<Builder<T>> creator) {
        TrackedValueBuilderImpl<T> builder = new TrackedValueBuilderImpl<T>(defaultValue, key0);
        creator.accept(builder);
        return builder.build();
    }

    public void invokeCallbacks();

    public void serializeAndInvokeCallbacks();

    @ApiStatus.NonExtendable
    public static interface Builder<T>
    extends MetadataContainerBuilder<Builder<T>> {
        public T getDefaultValue();

        public Builder<T> key(String var1);

        @Override
        public <M, B extends MetadataType.Builder<M>> Builder<T> metadata(MetadataType<M, B> var1, Consumer<B> var2);

        public Builder<T> constraint(Constraint<T> var1);

        public Builder<T> callback(UpdateCallback<T> var1);
    }

    public static interface UpdateCallback<T> {
        public void onUpdate(TrackedValue<T> var1);
    }
}

