/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import link.e4mc.Agnos;
import link.e4mc.Config;
import link.e4mc.Doctor;
import link.e4mc.Mirror;
import link.e4mc.PoisonPill;
import link.e4mc.QuiclimeSession;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.commands.BanListCommands;
import net.minecraft.server.commands.BanPlayerCommands;
import net.minecraft.server.commands.PardonCommand;
import net.minecraft.server.commands.WhitelistCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E4mcClient {
    public static final String MOD_ID = "e4mc_minecraft";
    public static QuiclimeSession session;
    public static final Logger LOGGER;
    public static boolean badurl;

    public static void init() {
        Config.INSTANCE.id();
        try {
            if (!PoisonPill.checkMotw()) {
                badurl = true;
                LOGGER.warn("MotW lists unknown source! Poison pill active!");
            }
        }
        catch (Exception e) {
            LOGGER.warn("MotW check failed!", (Throwable)e);
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (Config.INSTANCE.restoreDedicatedCommands.value().booleanValue() && Agnos.isClient()) {
            BanListCommands.m_136543_(dispatcher);
            BanPlayerCommands.m_136558_(dispatcher);
            PardonCommand.m_138093_(dispatcher);
            WhitelistCommand.m_139201_(dispatcher);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"e4mc").requires(src -> {
            if (src.m_81377_() == null) {
                return false;
            }
            if (src.m_81377_().m_6982_()) {
                return src.m_6761_(4);
            }
            try {
                return Mirror.isSingleplayerOwner(src.m_81377_(), src.m_81375_());
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).then(Commands.m_82127_((String)"stop").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STOPPED) {
                session.stop();
                Mirror.sendSuccessToSource((CommandSourceStack)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.closeServer", new Object[0]));
            } else {
                Mirror.sendFailureToSource((CommandSourceStack)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.serverAlreadyClosed", new Object[0]));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"doctor").executes(ctx -> {
            Thread thread = new Thread(() -> {
                LOGGER.info("generating e4mc doctor report");
                Mirror.sendSuccessToSource((CommandSourceStack)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.doctor.start", new Object[0]));
                String diag = Doctor.doctor();
                LOGGER.info("e4mc doctor report:\n{}", (Object)diag);
                Mirror.sendSuccessToSource((CommandSourceStack)ctx.getSource(), Mirror.literal(diag));
            }, "e4mc_minecraft-doctor");
            thread.setDaemon(true);
            thread.start();
            return 1;
        }))).then(Commands.m_82127_((String)"restart").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STARTED) {
                session.stop();
                session = new QuiclimeSession(E4mcClient.session.handler, E4mcClient.session.group);
                session.startAsync();
            }
            return 1;
        })));
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        badurl = false;
    }
}

