/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.core.common.recipes.EnderRecipe;
import com.enderio.machines.common.blockentity.EnchanterBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EnchanterRecipe
implements EnderRecipe<Container> {
    private final ResourceLocation id;
    private final Enchantment enchantment;
    private final int costMultiplier;
    private final CountedIngredient input;

    public EnchanterRecipe(ResourceLocation id, CountedIngredient input, Enchantment enchantment, int costMultiplier) {
        this.id = id;
        this.input = input;
        this.enchantment = enchantment;
        this.costMultiplier = costMultiplier;
    }

    public CountedIngredient getInput() {
        return this.input;
    }

    public int getCostMultiplier() {
        return this.costMultiplier;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getEnchantmentLevel(int ingredientCount) {
        return Math.min(ingredientCount / this.input.count(), this.enchantment.m_6586_());
    }

    public int getLapisForLevel(int level) {
        int res = this.getEnchantment().m_6586_() == 1 ? 5 : level;
        return Math.max(1, Math.round((float)res * ((Double)MachinesConfig.COMMON.ENCHANTER_LAPIS_COST_FACTOR.get()).floatValue()));
    }

    public int getInputAmountConsumed(Container container) {
        if (this.m_5818_(container, null)) {
            return this.getEnchantmentLevel(EnchanterBlockEntity.CATALYST.getItemStack(container).m_41613_()) * this.input.count();
        }
        return 0;
    }

    public int getXPCost(Container container) {
        int level = this.getEnchantmentLevel(EnchanterBlockEntity.CATALYST.getItemStack(container).m_41613_());
        return this.getXPCostForLevel(level);
    }

    public int getXPCostForLevel(int level) {
        level = Math.min(level, this.enchantment.m_6586_());
        int cost = this.getRawXPCostForLevel(level);
        if (level < this.enchantment.m_6586_()) {
            int nextCost = this.getXPCostForLevel(level + 1);
            cost = Math.max(nextCost / 2, cost);
        }
        return Math.max(1, cost);
    }

    private int getRawXPCostForLevel(int level) {
        double min = Math.max(1, this.enchantment.m_6183_(level));
        int cost = (int)Math.round((min *= (double)this.costMultiplier) * (Double)MachinesConfig.COMMON.ENCHANTER_LEVEL_COST_FACTOR.get());
        return cost += ((Integer)MachinesConfig.COMMON.ENCHANTER_BASE_LEVEL_COST.get()).intValue();
    }

    public ItemStack getBookForLevel(int level) {
        return EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(this.enchantment, level));
    }

    public boolean m_5818_(Container container, @Nullable Level level) {
        if (!EnchanterBlockEntity.BOOK.getItemStack(container).m_150930_(Items.f_42614_)) {
            return false;
        }
        if (!this.input.test(EnchanterBlockEntity.CATALYST.getItemStack(container)) || EnchanterBlockEntity.CATALYST.getItemStack(container).m_41613_() < this.input.count()) {
            return false;
        }
        return EnchanterBlockEntity.LAPIS.getItemStack(container).m_204117_(Tags.Items.GEMS_LAPIS) && EnchanterBlockEntity.LAPIS.getItemStack(container).m_41613_() >= this.getLapisForLevel(this.getEnchantmentLevel(EnchanterBlockEntity.CATALYST.getItemStack(container).m_41613_()));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.getBookForLevel(this.getEnchantmentLevel(EnchanterBlockEntity.CATALYST.getItemStack(container).m_41613_()));
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.ENCHANTING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.ENCHANTING.type().get();
    }

    public static class Serializer
    implements RecipeSerializer<EnchanterRecipe> {
        public EnchanterRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            CountedIngredient input = CountedIngredient.fromJson(serializedRecipe.get("input").getAsJsonObject());
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(serializedRecipe.get("enchantment").getAsString()));
            if (enchantment == null) {
                throw new ResourceLocationException("The enchantment in " + String.valueOf(recipeId) + " does not exist");
            }
            int costMultiplier = serializedRecipe.get("cost_multiplier").getAsInt();
            return new EnchanterRecipe(recipeId, input, enchantment, costMultiplier);
        }

        @Nullable
        public EnchanterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                CountedIngredient input = CountedIngredient.fromNetwork(buffer);
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_());
                if (enchantment == null) {
                    throw new ResourceLocationException("The enchantment in " + String.valueOf(recipeId) + " does not exist");
                }
                int level = buffer.readInt();
                return new EnchanterRecipe(recipeId, input, enchantment, level);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading enchanter recipe from packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, EnchanterRecipe recipe) {
            try {
                recipe.getInput().toNetwork(buffer);
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)recipe.getEnchantment())));
                buffer.writeInt(recipe.getCostMultiplier());
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing enchanter recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

