/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.MachineTankLayout;
import com.enderio.machines.common.io.fluid.TankAccess;
import com.enderio.machines.common.menu.XPObeliskMenu;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class XPObeliskBlockEntity
extends MachineBlockEntity {
    IntegerNetworkDataSlot xpTankDataSlot = new IntegerNetworkDataSlot(() -> TANK.getFluidAmount(this), amount -> TANK.setFluid(this, new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), amount.intValue())));
    private static final TankAccess TANK = new TankAccess();
    private static final Logger LOGGER = LogUtils.getLogger();

    public XPObeliskBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.addDataSlot(this.xpTankDataSlot);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new XPObeliskMenu(this, playerInventory, containerId);
    }

    @Override
    @Nullable
    public MachineTankLayout getTankLayout() {
        return new MachineTankLayout.Builder().tank(TANK, Integer.MAX_VALUE, fluidStack -> fluidStack.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE)).build();
    }

    @Override
    @Nullable
    protected MachineFluidHandler createFluidHandler(MachineTankLayout layout) {
        return new MachineFluidHandler(this.getIOConfig(), this.getTankLayout()){

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                XPObeliskBlockEntity.this.m_6596_();
            }

            @Override
            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (TANK.isFluidValid(this, resource)) {
                    Fluid currentFluid = TANK.getFluid(this).getFluid();
                    if (currentFluid == Fluids.f_76191_ || resource.getFluid().m_6212_(currentFluid)) {
                        return super.fill(resource, action);
                    }
                    return super.fill(new FluidStack(currentFluid, resource.getAmount()), action);
                }
                return 0;
            }
        };
    }

    public MachineFluidTank getFluidTank() {
        return TANK.getTank(this);
    }

    public void addLevelsToPlayer(Player player, int levelsToAdd) {
        long playerExperience = ExperienceUtil.getPlayerTotalXp(player);
        long targetExperience = ExperienceUtil.getTotalXpFromLevel(player.f_36078_ + levelsToAdd);
        this.addPlayerXp(player, targetExperience - playerExperience);
    }

    public void removeLevelsFromPlayer(Player player, int levelsToRemove) {
        long playerExperience = ExperienceUtil.getPlayerTotalXp(player);
        long targetExperience = ExperienceUtil.getTotalXpFromLevel(Math.max(0, player.f_36078_ - levelsToRemove));
        this.removePlayerXp(player, playerExperience - targetExperience);
    }

    public void addAllXpToPlayer(Player player) {
        long experienceToGive = TANK.getFluidAmount(this) / ExperienceUtil.EXP_TO_FLUID;
        this.addPlayerXp(player, experienceToGive);
    }

    public void removeAllXpFromPlayer(Player player) {
        long playerExperience = ExperienceUtil.getPlayerTotalXp(player);
        this.removePlayerXp(player, playerExperience);
    }

    private void addPlayerXp(Player player, long experience) {
        int xp;
        if (experience < 0L) {
            throw new IllegalArgumentException("experience cannot be negative");
        }
        long volume = experience * (long)ExperienceUtil.EXP_TO_FLUID;
        int cappedVolume = (int)Math.min(Integer.MAX_VALUE, volume);
        cappedVolume -= cappedVolume % ExperienceUtil.EXP_TO_FLUID;
        FluidStack drained = TANK.drain((MachineBlockEntity)this, cappedVolume, IFluidHandler.FluidAction.EXECUTE);
        for (int xpToAdd = drained.getAmount() / ExperienceUtil.EXP_TO_FLUID; xpToAdd > 0; xpToAdd -= xp) {
            xp = Mth.m_14045_((int)((int)Math.floor((1.0f - player.f_36080_) * (float)ExperienceUtil.getXpNeededForNextLevel(player.f_36078_))), (int)0, (int)xpToAdd);
            if (xp <= 0) {
                xp = Mth.m_14045_((int)ExperienceUtil.getXpNeededForNextLevel(player.f_36078_ + 1), (int)0, (int)xpToAdd);
            }
            if (xp <= 0) {
                LOGGER.error("xp <= 0 in addPlayerXp. experienceLevel: {}, experienceProgress: {}, xpToAdd: {}, xp: {}", new Object[]{player.f_36078_, Float.valueOf(player.f_36080_), xpToAdd, xp});
                throw new IllegalStateException("xp <= 0 in addPlayerXp.");
            }
            player.m_6756_(xp);
        }
    }

    private void removePlayerXp(Player player, long experience) {
        int xp;
        if (experience < 0L) {
            throw new IllegalArgumentException("experience cannot be negative");
        }
        long volume = experience * (long)ExperienceUtil.EXP_TO_FLUID;
        int cappedVolume = (int)Math.min(Integer.MAX_VALUE, volume);
        cappedVolume -= cappedVolume % ExperienceUtil.EXP_TO_FLUID;
        ForgeFlowingFluid fillFluid = EIOFluids.XP_JUICE.getSource();
        FluidStack currentFluid = TANK.getFluid(this);
        if (!currentFluid.isEmpty() && !currentFluid.getFluid().m_6212_((Fluid)fillFluid)) {
            fillFluid = currentFluid.getFluid();
        }
        int filled = TANK.fill(this, new FluidStack((Fluid)fillFluid, cappedVolume), IFluidHandler.FluidAction.EXECUTE);
        for (int xpToRemove = filled / ExperienceUtil.EXP_TO_FLUID; xpToRemove > 0; xpToRemove -= xp) {
            xp = Mth.m_14045_((int)((int)Math.floor(player.f_36080_ * (float)ExperienceUtil.getXpNeededForNextLevel(player.f_36078_))), (int)0, (int)xpToRemove);
            if (xp <= 0) {
                xp = Mth.m_14045_((int)ExperienceUtil.getXpNeededForNextLevel(player.f_36078_ - 1), (int)0, (int)xpToRemove);
            }
            if (xp <= 0) {
                LOGGER.error("xp <= 0 in removePlayerXp. experienceLevel: {}, experienceProgress: {}, xpToRemove: {}, xp: {}", new Object[]{player.f_36078_, Float.valueOf(player.f_36080_), xpToRemove, xp});
                throw new IllegalStateException("xp <= 0 in removePlayerXp.");
            }
            player.m_6756_(-xp);
        }
    }
}

