/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.filter.EntityFilter;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.machines.common.blockentity.base.ObeliskBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.menu.AversionObeliskMenu;
import com.enderio.machines.common.obelisk.AversionObeliskManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import org.jetbrains.annotations.Nullable;

public class AversionObeliskBlockEntity
extends ObeliskBlockEntity {
    private static final QuadraticScalable ENERGY_CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.AVERSION_CAPACITY);
    private static final QuadraticScalable ENERGY_USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.AVERSION_USAGE);

    public AversionObeliskBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, ENERGY_CAPACITY, ENERGY_USAGE, type, worldPosition, blockState);
    }

    @Override
    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AversionObeliskManager.getManager(serverLevel).ifPresent(obeliskManager -> obeliskManager.register(this));
        }
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AversionObeliskManager.getManager(serverLevel).ifPresent(obeliskManager -> obeliskManager.unregister(this));
        }
        super.m_7651_();
    }

    @Override
    protected void updateLocations() {
        super.updateLocations();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AversionObeliskManager.getManager(serverLevel).ifPresent(obeliskManager -> obeliskManager.update(this));
        }
    }

    @Override
    public MachineInventoryLayout createInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot((integer, itemStack) -> itemStack.getCapability(EIOCapabilities.FILTER).orElse(null) instanceof EntityFilter).slotAccess(FILTER).capacitor().build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new AversionObeliskMenu(this, pPlayerInventory, pContainerId);
    }

    @Override
    public int getMaxRange() {
        return 32;
    }

    @Override
    public String getColor() {
        return (String)MachinesConfig.CLIENT.BLOCKS.AVERSION_RANGE_COLOR.get();
    }

    public boolean handleSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        EntityFilter entityFilter;
        if (!this.isActive() || this.getAABB() == null) {
            return false;
        }
        Object object = FILTER.getItemStack(this).getCapability(EIOCapabilities.FILTER).orElse(null);
        if (object instanceof EntityFilter && !(entityFilter = (EntityFilter)object).test(event.getEntity())) {
            return false;
        }
        if (this.isActive() && this.getAABB().m_82393_(event.getX(), event.getY(), event.getZ())) {
            int cost = ENERGY_USAGE.base().get();
            int energy = this.getEnergyStorage().consumeEnergy(cost, true);
            if (energy == cost) {
                event.setSpawnCancelled(true);
                this.getEnergyStorage().consumeEnergy(cost, true);
                return true;
            }
        }
        return false;
    }
}

