/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class ListNetworkDataSlot<T, V extends Tag>
extends NetworkDataSlot<List<T>> {
    private final Function<T, V> serializer;
    private final Function<V, T> deSerializer;
    private final BiConsumer<T, FriendlyByteBuf> toBuffer;
    private final Function<FriendlyByteBuf, T> fromBuffer;

    public ListNetworkDataSlot(Supplier<List<T>> getter, Consumer<List<T>> setter, Function<T, V> serializer, Function<V, T> deSerializer, BiConsumer<T, FriendlyByteBuf> toBuffer, Function<FriendlyByteBuf, T> fromBuffer) {
        super(getter, setter);
        this.serializer = serializer;
        this.deSerializer = deSerializer;
        this.toBuffer = toBuffer;
        this.fromBuffer = fromBuffer;
    }

    @Override
    public Tag serializeValueNBT(List<T> value) {
        ListTag listTag = new ListTag();
        for (T t : value) {
            listTag.add((Object)((Tag)this.serializer.apply(t)));
        }
        return listTag;
    }

    @Override
    protected List<T> valueFromNBT(Tag nbt) {
        if (nbt instanceof ListTag) {
            ListTag listTag = (ListTag)nbt;
            ArrayList<T> list = new ArrayList<T>();
            for (Tag tag : listTag) {
                list.add(this.deSerializer.apply(tag));
            }
            return list;
        }
        throw new IllegalStateException("Invalid list tag was passed over the network.");
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, List<T> value) {
        buf.writeInt(value.size());
        for (T element : value) {
            this.toBuffer.accept(element, buf);
        }
    }

    @Override
    public List<T> valueFromBuffer(FriendlyByteBuf buf) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                list.add(this.fromBuffer.apply(buf));
            }
            return list;
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid list buffer was passed over the network.");
        }
    }
}

