/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class FloatNetworkDataSlot
extends NetworkDataSlot<Float> {
    public FloatNetworkDataSlot(Supplier<Float> getter, Consumer<Float> setter) {
        super(getter, setter);
    }

    @Override
    public Tag serializeValueNBT(Float value) {
        return FloatTag.m_128566_((float)value.floatValue());
    }

    @Override
    protected Float valueFromNBT(Tag nbt) {
        if (nbt instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)nbt;
            return Float.valueOf(floatTag.m_7057_());
        }
        throw new IllegalStateException("Invalid float tag was passed over the network.");
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Float value) {
        buf.writeFloat(value.floatValue());
    }

    @Override
    public Float valueFromBuffer(FriendlyByteBuf buf) {
        try {
            return Float.valueOf(buf.readFloat());
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid float buffer was passed over the network.");
        }
    }
}

