/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.network.Packet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EmitParticlePacket
implements Packet {
    private final double x;
    private final double y;
    private final double z;
    private final double xSpeed;
    private final double ySpeed;
    private final double zSpeed;
    private final ParticleOptions particleOptions;

    public EmitParticlePacket(ParticleOptions type, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.particleOptions = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
    }

    public EmitParticlePacket(ParticleOptions type, BlockPos pos) {
        this(type, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
    }

    public EmitParticlePacket(ParticleOptions type, BlockPos pos, double xSpeed, double ySpeed, double zSpeed) {
        this(type, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, xSpeed, ySpeed, zSpeed);
    }

    public EmitParticlePacket(FriendlyByteBuf buf) {
        this.particleOptions = this.readParticle(buf, Objects.requireNonNull((ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buf.m_130281_())));
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.xSpeed = buf.readDouble();
        this.ySpeed = buf.readDouble();
        this.zSpeed = buf.readDouble();
    }

    private <T extends ParticleOptions> T readParticle(FriendlyByteBuf buf, ParticleType<T> type) {
        return (T)type.m_123743_().m_6507_(type, buf);
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130085_(Objects.requireNonNull(ForgeRegistries.PARTICLE_TYPES.getKey((Object)this.particleOptions.m_6012_())));
        writeInto.writeDouble(this.x);
        writeInto.writeDouble(this.y);
        writeInto.writeDouble(this.z);
        writeInto.writeDouble(this.xSpeed);
        writeInto.writeDouble(this.ySpeed);
        writeInto.writeDouble(this.zSpeed);
        this.particleOptions.m_7711_(writeInto);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Minecraft.m_91087_().f_91073_.m_7106_(this.particleOptions, this.x, this.y, this.z, this.xSpeed, this.ySpeed, this.zSpeed);
    }

    public static class Handler
    extends Packet.PacketHandler<EmitParticlePacket> {
        @Override
        public EmitParticlePacket fromNetwork(FriendlyByteBuf buf) {
            return new EmitParticlePacket(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }

        @Override
        public void toNetwork(EmitParticlePacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }
    }
}

