/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.network.C2SDataSlotChange;
import com.enderio.core.common.network.EmitParticlePacket;
import com.enderio.core.common.network.EmitParticlesPacket;
import com.enderio.core.common.network.Packet;
import com.enderio.core.common.network.S2CDataSlotUpdate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class CoreNetwork {
    private static final String PROTOCOL_VERSION = "1.0";
    private static SimpleChannel CHANNEL;
    private static int packetId;

    public static void networkInit() {
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("enderio", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        CoreNetwork.registerPacket(new EmitParticlePacket.Handler(), EmitParticlePacket.class);
        CoreNetwork.registerPacket(new EmitParticlesPacket.Handler(), EmitParticlesPacket.class);
        CoreNetwork.registerPacket(new S2CDataSlotUpdate.Handler(), S2CDataSlotUpdate.class);
        CoreNetwork.registerPacket(new C2SDataSlotChange.Handler(), C2SDataSlotChange.class);
    }

    public static <P extends Packet> void sendToServer(P packet) {
        CHANNEL.sendToServer(packet);
    }

    public static <P extends Packet> void sendToPlayer(ServerPlayer player, P packet) {
        CoreNetwork.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static <P extends Packet> void sendToTracking(LevelChunk chunk, P packet) {
        CoreNetwork.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), packet);
    }

    public static <P extends Packet> void sendToDimension(ResourceKey<Level> dim, P packet) {
        CoreNetwork.send(PacketDistributor.DIMENSION.with(() -> dim), packet);
    }

    public static <P extends Packet> void send(PacketDistributor.PacketTarget target, P packet) {
        CHANNEL.send(target, packet);
    }

    public static <P extends Packet> void registerPacket(Packet.PacketHandler<P> handler, Class<P> clazz) {
        CHANNEL.registerMessage(CoreNetwork.id(), clazz, handler::toNetwork, handler::fromNetwork, handler, handler.getDirection());
    }

    private static int id() {
        return packetId++;
    }

    static {
        packetId = 0;
    }
}

