/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.network;

import com.enderio.api.misc.ColorControl;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.common.redstone.DoubleRedstoneChannel;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record DoubleChannelPacket(ColorControl channel1, ColorControl channel2) implements Packet
{
    public DoubleChannelPacket(FriendlyByteBuf buf) {
        this((ColorControl)buf.m_130066_(ColorControl.class), (ColorControl)buf.m_130066_(ColorControl.class));
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getSender() != null;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack mainHandItem = context.getSender().m_21205_();
        mainHandItem.getCapability(EIOCapabilities.FILTER).ifPresent(filter -> {
            if (filter instanceof DoubleRedstoneChannel) {
                DoubleRedstoneChannel doubleRedstoneChannel = (DoubleRedstoneChannel)((Object)filter);
                doubleRedstoneChannel.setChannels(this.channel1, this.channel2);
            }
        });
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130068_((Enum)this.channel1);
        writeInto.m_130068_((Enum)this.channel2);
    }

    public static class Handler
    extends Packet.PacketHandler<DoubleChannelPacket> {
        @Override
        public DoubleChannelPacket fromNetwork(FriendlyByteBuf buf) {
            return new DoubleChannelPacket(buf);
        }

        @Override
        public void toNetwork(DoubleChannelPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

