/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.redstone;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.IOAwareConduitTicker;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.conduit.type.redstone.RedstoneConduitData;
import com.enderio.conduits.common.init.ConduitBlocks;
import com.enderio.conduits.common.redstone.RedstoneExtractFilter;
import com.enderio.conduits.common.tag.ConduitTags;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneConduitTicker
implements IOAwareConduitTicker<RedstoneConduitData> {
    private final Map<ColorControl, Integer> activeColors = new EnumMap<ColorControl, Integer>(ColorControl.class);

    @Override
    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        BlockPos neighbor = conduitPos.m_121945_(direction);
        BlockState blockState = level.m_8055_(neighbor);
        return blockState.m_204336_(ConduitTags.Blocks.REDSTONE_CONNECTABLE) || blockState.canRedstoneConnectTo((BlockGetter)level, neighbor, direction);
    }

    @Override
    public boolean canForceConnect(Level level, BlockPos conduitPos, Direction direction) {
        BlockPos neighbor = conduitPos.m_121945_(direction);
        BlockState blockState = level.m_8055_(neighbor);
        return !blockState.m_60795_();
    }

    @Override
    public void tickGraph(ServerLevel level, ConduitType<RedstoneConduitData> type, ConduitGraph<RedstoneConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        Collection<ConduitNode<RedstoneConduitData>> nodeIdentifiers = graph.getNodes();
        this.activeColors.clear();
        this.tickGraph(level, type, nodeIdentifiers.stream().filter(node -> this.isLoaded((Level)level, node.getPos())).toList(), graph, coloredRedstoneProvider);
        for (ConduitNode<RedstoneConduitData> nodeIdentifier : nodeIdentifiers) {
            RedstoneConduitData data = nodeIdentifier.getConduitData();
            data.clearActive();
            for (Map.Entry<ColorControl, Integer> entry : this.activeColors.entrySet()) {
                data.setActiveColor(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void tickColoredGraph(ServerLevel level, ConduitType<RedstoneConduitData> type, List<IOAwareConduitTicker.Connection<RedstoneConduitData>> inserts, List<IOAwareConduitTicker.Connection<RedstoneConduitData>> extracts, ColorControl color, ConduitGraph<RedstoneConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        for (IOAwareConduitTicker.Connection<RedstoneConduitData> extract : extracts) {
            int signal;
            ResourceFilter resourceFilter = extract.extractFilter();
            if (resourceFilter instanceof RedstoneExtractFilter) {
                RedstoneExtractFilter filter = (RedstoneExtractFilter)resourceFilter;
                signal = filter.getInputSignal((Level)level, extract.move(), extract.dir());
            } else {
                signal = level.m_277185_(extract.move(), extract.dir());
            }
            if (signal <= 0) continue;
            this.activeColors.put(color, Math.max(this.activeColors.getOrDefault(color, 0), signal));
        }
        for (IOAwareConduitTicker.Connection<RedstoneConduitData> insert : inserts) {
            level.m_46586_(insert.move(), (Block)ConduitBlocks.CONDUIT.get(), insert.pos());
        }
    }

    @Override
    public boolean shouldSkipColor(List<IOAwareConduitTicker.Connection<RedstoneConduitData>> extractList, List<IOAwareConduitTicker.Connection<RedstoneConduitData>> insertList) {
        return extractList.isEmpty() && insertList.isEmpty();
    }

    @Override
    public int getTickRate() {
        return 2;
    }
}

