/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.client.model.conduit.modifier;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.model.ConduitCoreModelModifier;
import com.enderio.api.conduit.model.RegisterConduitCoreModelModifiersEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.Nullable;

public class ConduitCoreModelModifiers {
    private static Map<ConduitType<?>, ConduitCoreModelModifier<?>> MODIFIERS;

    @UseOnly(value=LogicalSide.CLIENT)
    public static void init() {
        RegisterConduitCoreModelModifiersEvent event = new RegisterConduitCoreModelModifiersEvent();
        ModLoader.get().postEvent((Event)event);
        Map<ConduitType<?>, RegisterConduitCoreModelModifiersEvent.ConduitCoreModelModifierFactory<?>> factories = event.getModifiers();
        MODIFIERS = new HashMap();
        factories.forEach((t, f) -> MODIFIERS.put((ConduitType<?>)t, f.createModifier()));
    }

    @UseOnly(value=LogicalSide.CLIENT)
    @Nullable
    public static <T extends ConduitData<T>> ConduitCoreModelModifier<T> getModifier(ConduitType<T> type) {
        return MODIFIERS.get(type);
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public static Set<ResourceLocation> getAllModelDependencies() {
        return MODIFIERS.values().stream().flatMap(modifier -> modifier.getModelDependencies().stream()).collect(Collectors.toSet());
    }
}

