/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.network;

import com.enderio.api.travel.ITravelTarget;
import com.enderio.api.travel.TravelRegistry;
import com.enderio.base.common.travel.TravelSavedData;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class AddTravelTargetPacket
implements Packet {
    @Nullable
    private final ITravelTarget target;

    public AddTravelTargetPacket(ITravelTarget target) {
        this.target = target;
    }

    public AddTravelTargetPacket(FriendlyByteBuf buf) {
        this.target = TravelRegistry.deserialize(buf.m_130260_()).orElse(null);
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130079_(this.target.save());
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientHandler.handle(this.target);
    }

    public static class ClientHandler {
        static void handle(ITravelTarget target) {
            TravelSavedData travelData = TravelSavedData.getTravelData((Level)Minecraft.m_91087_().f_91073_);
            travelData.addTravelTarget((Level)Minecraft.m_91087_().f_91073_, target);
        }
    }

    public static class Handler
    extends Packet.PacketHandler<AddTravelTargetPacket> {
        @Override
        public AddTravelTargetPacket fromNetwork(FriendlyByteBuf buf) {
            return new AddTravelTargetPacket(buf);
        }

        @Override
        public void toNetwork(AddTravelTargetPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

