/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.menu;

import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOMenus;
import com.enderio.base.common.network.FilterUpdatePacket;
import com.enderio.core.common.capability.FluidFilterCapability;
import com.enderio.core.common.menu.FluidFilterSlot;
import com.enderio.core.common.network.CoreNetwork;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterMenu
extends AbstractContainerMenu {
    private final ItemStack stack;
    private final FluidFilterCapability capability;

    public FluidFilterMenu(MenuType<?> pMenuType, int pContainerId, Inventory inventory, ItemStack stack) {
        super(pMenuType, pContainerId);
        this.stack = stack;
        LazyOptional resourceFilter = stack.getCapability(EIOCapabilities.FILTER);
        this.capability = (FluidFilterCapability)resourceFilter.map(filter -> {
            if (filter instanceof FluidFilterCapability) {
                FluidFilterCapability cap = (FluidFilterCapability)filter;
                return cap;
            }
            throw new IllegalArgumentException();
        }).orElseThrow(IllegalArgumentException::new);
        for (int i = 0; i < this.capability.size(); ++i) {
            int pSlot = i;
            this.m_38897_(new FluidFilterSlot(fluidStack -> this.capability.setEntry(pSlot, (FluidStack)fluidStack), i, 14 + i % 5 * 18, 35 + 20 * (i / 5)));
        }
        this.addInventorySlots(14, 119, inventory);
    }

    public FluidFilterMenu(int pContainerId, Inventory inventory, ItemStack stack) {
        this((MenuType)EIOMenus.FLUID_FILTER.get(), pContainerId, inventory, stack);
    }

    public static FluidFilterMenu factory(@Nullable MenuType<FluidFilterMenu> pMenuType, int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        return new FluidFilterMenu((MenuType)EIOMenus.FLUID_FILTER.get(), pContainerId, inventory, inventory.f_35978_.m_21205_());
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        return pPlayer.m_21205_().equals(this.stack);
    }

    public void addInventorySlots(int xPos, int yPos, Inventory inventory) {
        for (int x = 0; x < 9; ++x) {
            Slot ref = new Slot((Container)inventory, x, xPos + x * 18, yPos + 58);
            this.m_38897_(ref);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot ref = new Slot((Container)inventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18);
                this.m_38897_(ref);
            }
        }
    }

    public FluidFilterCapability getFilter() {
        return this.capability;
    }

    public void setNbt(Boolean nbt) {
        CoreNetwork.sendToServer(new FilterUpdatePacket(nbt, this.capability.isInvert()));
        this.capability.setNbt(nbt);
    }

    public void setInverted(Boolean inverted) {
        CoreNetwork.sendToServer(new FilterUpdatePacket(this.capability.isNbt(), inverted));
        this.capability.setInverted(inverted);
    }

    public void m_150430_(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0 && slotId < this.capability.size()) {
            if (clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE) {
                return;
            }
            if (!this.capability.getEntry(slotId).isEmpty()) {
                this.capability.setEntry(slotId, FluidStack.EMPTY);
            }
        }
        super.m_150430_(slotId, button, clickType, player);
    }
}

