/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.capability.EnergyStorageItemStack;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.handler.TravelHandler;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.item.IAdvancedTooltipProvider;
import com.enderio.core.common.item.ITabVariants;
import com.enderio.core.common.util.EnergyUtil;
import com.enderio.core.common.util.TooltipUtil;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class TravelStaffItem
extends Item
implements IMultiCapabilityItem,
IAdvancedTooltipProvider,
ITabVariants {
    public TravelStaffItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (this.getActivationStatus(stack).isAir()) {
            if (this.tryPerformAction(level, player, stack)) {
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(level, player, usedHand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this.getActivationStatus(context.m_43722_()).isBlock()) {
            if (context.m_43723_() != null && this.tryPerformAction(context.m_43725_(), context.m_43723_(), context.m_43722_())) {
                return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
            }
            return InteractionResult.FAIL;
        }
        return super.m_6225_(context);
    }

    private boolean tryPerformAction(Level level, Player player, ItemStack stack) {
        boolean isCreative = player.m_7500_();
        if (this.hasResources(stack) || isCreative) {
            if (this.performAction(level, player, stack)) {
                if (!level.m_5776_() && !isCreative) {
                    this.consumeResources(stack);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean performAction(Level level, Player player, ItemStack stack) {
        if (player.m_6144_()) {
            if (TravelHandler.shortTeleport(level, player)) {
                player.m_36335_().m_41524_((Item)this, ((Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_BLINK_DISABLED_TIME.get()).intValue());
                return true;
            }
        } else if (TravelHandler.blockTeleport(level, player)) {
            player.m_36335_().m_41524_((Item)this, ((Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_BLINK_DISABLED_TIME.get()).intValue());
            return true;
        }
        return false;
    }

    public int getMaxEnergy() {
        return (Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_STAFF_MAX_ENERGY.get();
    }

    public boolean hasResources(ItemStack stack) {
        return EnergyUtil.hasEnergy(stack, (Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_STAFF_ENERGY_USE.get());
    }

    public void consumeResources(ItemStack stack) {
        EnergyUtil.extractEnergy(stack, (Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_STAFF_ENERGY_USE.get(), false);
    }

    @Override
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(ForgeCapabilities.ENERGY, LazyOptional.of(() -> new EnergyStorageItemStack(stack, this.getMaxEnergy())));
        return provider;
    }

    protected ActivationStatus getActivationStatus(ItemStack stack) {
        return ActivationStatus.ALL;
    }

    @Override
    public void addAllVariants(CreativeModeTabModifier modifier) {
        modifier.m_246326_((ItemLike)this);
        ItemStack is = new ItemStack((ItemLike)this);
        EnergyUtil.setFull(is);
        modifier.m_246342_(is);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(energyStorage -> Math.round((float)energyStorage.getEnergyStored() * 13.0f / (float)energyStorage.getMaxEnergyStored())).orElse(0);
    }

    public int m_142159_(ItemStack pStack) {
        return 11626724;
    }

    @Override
    public void addCommonTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        String energy = String.format("%,d", EnergyUtil.getEnergyStored(itemStack)) + "/" + String.format("%,d", EnergyUtil.getMaxEnergyStored(itemStack));
        tooltips.add(TooltipUtil.styledWithArgs(EIOLang.ENERGY_AMOUNT, energy));
    }

    protected static enum ActivationStatus {
        BLOCK(true, false),
        AIR(false, true),
        ALL(true, true);

        private final boolean isBlock;
        private final boolean isAir;

        private ActivationStatus(boolean isBlock, boolean isAir) {
            this.isBlock = isBlock;
            this.isAir = isAir;
        }

        public boolean isBlock() {
            return this.isBlock;
        }

        public boolean isAir() {
            return this.isAir;
        }
    }
}

