/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.renderer;

import com.enderio.base.common.block.painted.IPaintedBlock;
import com.enderio.base.common.blockentity.DoublePaintedBlockEntity;
import com.enderio.base.common.blockentity.IPaintableBlockEntity;
import com.enderio.base.common.util.PaintUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PaintedBlockColor
implements BlockColor,
ItemColor {
    public int m_92566_(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity entity;
        if (level != null && pos != null && (entity = level.m_7702_(pos)) instanceof IPaintableBlockEntity) {
            IPaintableBlockEntity paintedBlockEntity = (IPaintableBlockEntity)entity;
            Block[] paints = paintedBlockEntity.getPaints();
            if (paintedBlockEntity instanceof DoublePaintedBlockEntity) {
                DoublePaintedBlockEntity doublePaintedBlockEntity = (DoublePaintedBlockEntity)paintedBlockEntity;
                if (tintIndex < 0) {
                    tintIndex = PaintedBlockColor.unmoveTintIndex(tintIndex);
                    if (paints[0] != null) {
                        BlockState paintState = paints[0].m_49966_();
                        int color = Minecraft.m_91087_().m_91298_().m_92577_(paintState, level, pos, tintIndex);
                        if (color != -1) {
                            return color;
                        }
                    }
                    return 0;
                }
                tintIndex = PaintedBlockColor.unmoveTintIndex(tintIndex);
                if (paints[1] != null) {
                    BlockState paintState = paints[1].m_49966_();
                    int color = Minecraft.m_91087_().m_91298_().m_92577_(paintState, level, pos, tintIndex);
                    if (color != -1) {
                        return color;
                    }
                }
                return 0;
            }
            for (int i = 0; i < paints.length; ++i) {
                Block paint = paints[i];
                if (paint == null) continue;
                BlockState paintState = paint.m_49966_();
                if (paint instanceof IPaintedBlock) continue;
                int color = Minecraft.m_91087_().m_91298_().m_92577_(paintState, level, pos, i == 1 ? PaintedBlockColor.unmoveTintIndex(tintIndex) : tintIndex);
                if (color == -1) continue;
                return color;
            }
        }
        return 0xFFFFFF;
    }

    public int m_92671_(ItemStack itemStack, int tintIndex) {
        CompoundTag blockEntityTag;
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("BlockEntityTag") && (blockEntityTag = itemStack.m_41783_().m_128469_("BlockEntityTag")).m_128441_("Paint")) {
            Block paint = PaintUtils.getBlockFromRL(blockEntityTag.m_128461_("Paint"));
            if (paint == null) {
                return 0;
            }
            return Minecraft.m_91087_().getItemColors().m_92676_(paint.m_5456_().m_7968_(), tintIndex);
        }
        return 0;
    }

    public static int moveTintIndex(int original) {
        return -original - 2;
    }

    public static int unmoveTintIndex(int original) {
        if (original > 0) {
            return original;
        }
        return -original + 2;
    }
}

