/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.model;

import com.enderio.base.client.model.PaintedBlockModel;
import com.enderio.base.common.util.PaintUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class PaintedBlockGeometry
implements IUnbakedGeometry<PaintedBlockGeometry> {
    private final Block reference;
    @Nullable
    private final Direction rotateItemTo;

    public PaintedBlockGeometry(Block reference, @Nullable Direction rotateItemTo) {
        this.reference = reference;
        this.rotateItemTo = rotateItemTo;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new PaintedBlockModel(this.reference, this.rotateItemTo);
    }

    public static class Loader
    implements IGeometryLoader<PaintedBlockGeometry> {
        public PaintedBlockGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new PaintedBlockGeometry(PaintUtils.getBlockFromRL(jsonObject.get("reference").getAsString()), Loader.getItemTextureRotation(jsonObject));
        }

        @Nullable
        private static Direction getItemTextureRotation(JsonObject jsonObject) {
            if (jsonObject.has("item_texture_rotation")) {
                return Arrays.stream(Direction.values()).filter(dir -> dir.m_122433_().equals(jsonObject.get("item_texture_rotation").getAsString())).findFirst().orElse(null);
            }
            return null;
        }
    }
}

