/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api.util;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class KnightLibUtil {
    private KnightLibUtil() {
    }

    public static boolean isEntityBehind(Entity from, Entity to, double fov) {
        if (from == null || to == null) {
            return false;
        }
        Vec3 toTarget = new Vec3(to.m_20185_(), from.m_20186_(), to.m_20189_()).m_82546_(from.m_20182_()).m_82541_();
        double angle = Math.acos(from.m_20154_().m_82541_().m_82526_(toTarget)) * 57.29577951308232;
        return angle >= fov / 2.0;
    }

    @Nullable
    public static Entity raycastEntity(Entity exception, Level level, Vec3 start, Vec3 end) {
        return KnightLibUtil.raycastEntity(exception, level, start, end, e -> true);
    }

    @Nullable
    public static Entity raycastEntity(Entity exception, Level level, Vec3 start, Vec3 end, Predicate<Entity> predicate) {
        EntityHitResult hit = ProjectileUtil.m_37304_((Level)level, (Entity)exception, (Vec3)start, (Vec3)end, (AABB)new AABB(start, end), predicate);
        if (hit == null) {
            return null;
        }
        return hit.m_82443_();
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Entity center, Class<T> entityType, double radius) {
        return KnightLibUtil.getNearestEntity(center, entityType, radius, e -> true);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Entity center, Class<T> entityType, double radius, Predicate<T> filter) {
        return center.m_9236_().m_45976_(entityType, center.m_20191_().m_82400_(radius)).stream().filter(e -> !e.equals((Object)center)).filter(filter).min(Comparator.comparingDouble(arg_0 -> ((Entity)center).m_20280_(arg_0)));
    }

    public static List<Entity> getEntitiesInDirection(Entity from, Vec3 direction, double range, double angleRadians) {
        return from.m_9236_().m_6249_(from, from.m_20191_().m_82400_(range), e -> {
            if ((double)from.m_20270_(e) > range) {
                return false;
            }
            Vec3 flat = KnightLibUtil.flattenXZ(e.m_20182_().m_82546_(from.m_20182_()));
            if (flat.equals((Object)Vec3.f_82478_)) {
                return false;
            }
            return Math.acos(Math.max(-1.0, Math.min(1.0, KnightLibUtil.flattenXZ(direction).m_82526_(flat)))) <= angleRadians / 2.0;
        });
    }

    public static Vec3 flattenXZ(Vec3 vector) {
        Vec3 flat = new Vec3(vector.f_82479_, 0.0, vector.f_82481_);
        return flat.m_82556_() < 1.0E-6 ? Vec3.f_82478_ : flat.m_82541_();
    }

    public static boolean hasLineOfSight(Entity from, Entity to, boolean ignoreWater, boolean ignoreLava) {
        BlockHitResult result = from.m_9236_().m_45547_(new ClipContext(from.m_146892_(), to.m_146892_(), ClipContext.Block.COLLIDER, ignoreWater && ignoreLava ? ClipContext.Fluid.NONE : ClipContext.Fluid.ANY, from));
        return result.m_6662_() == HitResult.Type.MISS;
    }

    public static boolean hasLineOfSight(Entity from, Entity to) {
        return KnightLibUtil.hasLineOfSight(from, to, true, true);
    }

    public static List<Entity> getEntitiesInLineOfSight(LivingEntity from, double range, double angleRadians, Predicate<Entity> filter) {
        Vec3 eye = from.m_146892_();
        return from.m_9236_().m_6249_((Entity)from, new AABB(eye, eye).m_82400_(range), e -> !e.equals((Object)from) && filter.test((Entity)e)).stream().filter(e -> {
            Vec3 vec3;
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                vec3 = living.m_146892_();
            } else {
                vec3 = e.m_20191_().m_82399_().m_82546_(eye);
            }
            Vec3 toTarget = vec3;
            double dist = toTarget.m_82553_();
            if (dist > range) {
                return false;
            }
            return Math.acos(Math.max(-1.0, Math.min(1.0, from.m_20252_(1.0f).m_82541_().m_82526_(toTarget.m_82490_(1.0 / dist))))) <= angleRadians / 2.0;
        }).collect(Collectors.toList());
    }

    public static List<Entity> getEntitiesInLineOfSight(LivingEntity entity, double range) {
        return KnightLibUtil.getEntitiesInLineOfSight(entity, range, Math.toRadians(60.0), e -> true);
    }

    public static boolean canSee(LivingEntity from, Entity to, double maxDistance, double fovRad, boolean checkLOS) {
        if ((double)from.m_20270_(to) > maxDistance) {
            return false;
        }
        Vec3 flat = KnightLibUtil.flattenXZ(to.m_146892_().m_82546_(from.m_146892_()));
        if (flat.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        return Math.acos(Math.max(-1.0, Math.min(1.0, KnightLibUtil.flattenXZ(from.m_20252_(1.0f)).m_82526_(flat)))) <= fovRad / 2.0 && (!checkLOS || KnightLibUtil.hasLineOfSight((Entity)from, to));
    }

    public static boolean canSee(LivingEntity from, Entity to, double maxDistance, double fovRad) {
        return KnightLibUtil.canSee(from, to, maxDistance, fovRad, true);
    }

    public static Vec3 predictPosition(Entity entity, int ticks, Vec3 movement) {
        Vec3 vel = entity.m_20184_();
        Vec3 pos = entity.m_20182_();
        return pos.m_82549_(vel.m_82490_((double)ticks)).m_82549_(movement.m_82490_(0.5 * (double)ticks * (double)ticks));
    }

    public static Vec3 predictPosition(Entity entity, int ticks) {
        return KnightLibUtil.predictPosition(entity, ticks, entity.m_20184_());
    }

    public static List<Entity> getEntitiesInCircle(Level level, Vec3 center, double radius, Predicate<Entity> predicate) {
        return level.m_6249_((Entity)null, new AABB(center, center).m_82400_(radius), e -> e.m_20182_().m_82554_(center) <= radius && predicate.test((Entity)e));
    }

    public static BlockPos findClosestGroundBelow(LivingEntity entity, float y) {
        Vec3 start = new Vec3(entity.m_20185_(), entity.m_20191_().f_82289_ + 0.01, entity.m_20189_());
        BlockHitResult trace = entity.m_9236_().m_45547_(new ClipContext(start, start.m_82492_(0.0, (double)y, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (trace.m_6662_() == HitResult.Type.BLOCK) {
            return trace.m_82425_();
        }
        return null;
    }

    public static float normalizeDeg(float deg) {
        return (deg %= 360.0f) < 0.0f ? deg + 360.0f : deg;
    }

    public static float degToRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static Vec3 bezier(Vec3 a, Vec3 b, Vec3 c, double t) {
        double u = 1.0 - t;
        double tt = t * t;
        double uu = u * u;
        return new Vec3(uu * a.f_82479_ + 2.0 * u * t * b.f_82479_ + tt * c.f_82479_, uu * a.f_82480_ + 2.0 * u * t * b.f_82480_ + tt * c.f_82480_, uu * a.f_82481_ + 2.0 * u * t * b.f_82481_ + tt * c.f_82481_);
    }

    public static double estimateLengthBezier(Vec3 a, Vec3 b, Vec3 c) {
        double len = 0.0;
        Vec3 prev = a;
        for (int i = 1; i <= 24; ++i) {
            double t = (double)i / 24.0;
            Vec3 cur = KnightLibUtil.bezier(a, b, c, t);
            len += cur.m_82554_(prev);
            prev = cur;
        }
        return len;
    }

    public static Vec3 rotateHorizontalDirection(Vec3 direction, double degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new Vec3(direction.f_82479_ * cos - direction.f_82481_ * sin, direction.f_82480_, direction.f_82479_ * sin + direction.f_82481_ * cos);
    }

    public static BlockPos findValidSpawnPos(BlockPos pos, Level level) {
        if (KnightLibUtil.isValidSpawnPos(pos, level)) {
            return pos;
        }
        for (int d = 1; d <= 6; ++d) {
            BlockPos below = pos.m_6625_(d);
            if (!KnightLibUtil.isValidSpawnPos(below, level)) continue;
            return below;
        }
        for (int u = 1; u <= 3; ++u) {
            BlockPos above = pos.m_6630_(u);
            if (!KnightLibUtil.isValidSpawnPos(above, level)) continue;
            return above;
        }
        return pos;
    }

    private static boolean isValidSpawnPos(BlockPos pos, Level level) {
        return level.m_46739_(pos) && level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    public static Vec3 randomVectorInCone(Vec3 base, double maxAngleDegrees, Random random) {
        Vec3 baseNorm = base.m_82541_();
        Vec3 u = baseNorm.m_82537_(new Vec3(0.0, 1.0, 0.0));
        if (u.m_82556_() < 1.0E-6) {
            u = baseNorm.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        u = u.m_82541_();
        Vec3 v = baseNorm.m_82537_(u).m_82541_();
        double minCos = Math.cos(Math.toRadians(maxAngleDegrees));
        double cos = minCos + random.nextDouble() * (1.0 - minCos);
        double sin = Math.sqrt(1.0 - cos * cos);
        double phi = random.nextDouble() * 2.0 * Math.PI;
        return baseNorm.m_82490_(cos).m_82549_(u.m_82490_(sin * Math.cos(phi))).m_82549_(v.m_82490_(sin * Math.sin(phi))).m_82490_(base.m_82553_());
    }

    public static ListTag floatsToList(float[] arr) {
        ListTag list = new ListTag();
        for (float v : arr) {
            list.add((Object)FloatTag.m_128566_((float)v));
        }
        return list;
    }

    public static ListTag intsToList(int[] arr) {
        ListTag list = new ListTag();
        for (int v : arr) {
            list.add((Object)IntTag.m_128679_((int)v));
        }
        return list;
    }

    public static void listToFloats(ListTag list, float[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((FloatTag)list.get(i)).m_7057_();
        }
    }

    public static void listToInts(ListTag list, int[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((IntTag)list.get(i)).m_7047_();
        }
    }
}

